% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rpt.r
\name{viperRPT}
\alias{viperRPT}
\title{viperRPT}
\usage{
viperRPT(vipermat, expmat, weights = matrix(1, nrow(vipermat),
  ncol(vipermat), dimnames = list(rownames(vipermat), colnames(vipermat))),
  method = c("spline", "lineal", "rank"), robust = FALSE, cores = 1)
}
\arguments{
\item{vipermat}{Numeric matrix containing the viper protein activity inferences}

\item{expmat}{Numeric matrix or expressionSet containing the expression data}

\item{weights}{List of numeric matrix of sample weights}

\item{method}{Character string indicating the method to use, either rank, lineal or spline}

\item{robust}{Logical, whether the contribution of outliers is down-weighted by using a gaussian kernel estimate for the join probability density}

\item{cores}{Integer indicating the number of cores to use}
}
\value{
Matrix of RPT-activity values
}
\description{
This function computes residual post-translational activity
}
\examples{
data(bcellViper, package="bcellViper")
vipermat <- viper(dset, regulon)
rpt <- viperRPT(vipermat, dset)
rpt[1:5, 1:5]
}
\seealso{
\code{\link{viper}}
}
