% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clases.r
\name{msviper-class}
\alias{msviper-class}
\title{The msviper class}
\description{
This class contains the results generated by the msviper function
}
\section{Slots}{

   \describe{
     \item{\code{signature}:}{Matrix containing the gene expression signature}
     \item{\code{regulon}:}{Object of class \code{regulon}}

     \item{\code{es}:}{List containing 6 objects:}
       \item{\code{es$es}:}{Named vector of class \code{numeric} containing the enrichment scores}
       \item{\code{es$nes}:}{Named vector of class \code{numeric} containing the normalized enrichment scores}
       \item{\code{es$nes.se}:}{Named vector of class \code{numeric} containing the standard error for the normalized enrichment score}
       \item{\code{es$size}:}{Named vector of class \code{numeric} containing the size -number of target genes- for each regulator}
       \item{\code{es$p.value}:}{Named vector of class \code{numeric} containing the enrichment p-values}
       \item{\code{es$nes.bt}:}{Matrix containing the normalized enrichment score if the msviper test is performed with bootstraps}

     \item{\code{param}:}{List containing 3 elements:}
       \item{\code{param$minsize}:}{Integer indicating the minimum allowed size for the regulons}
       \item{\code{param$adaptive.size}:}{Logical indicating whether the weight (likelihood) should be used for computing the regulon size}
       \item{\code{param$iterative}:}{Logical indicating whether a two step analysis with adaptive redundancy estimation should be performed}

     \item{\code{nullmodel}:}{Matrix of genes by permutations containing the NULL model signatures}
     \item{\code{ledge}:}{List containing the leading edge genes for each regulator. This slot is added by the \code{ledge} function}
     \item{\code{shadow}:}{Two columns matrix containing the gene names for the shadow pairs. The first column contain the most probble regulator and the second column the one that was identified because a shadow effect}
   }
}

