% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_prediction.R
\docType{methods}
\name{get_prediction}
\alias{get_prediction}
\alias{get_prediction,lmerMod-method}
\alias{get_prediction,lm-method}
\title{Compute predicted value of formula for linear (mixed) model}
\usage{
get_prediction(fit, formula)

\S4method{get_prediction}{lmerMod}(fit, formula)

\S4method{get_prediction}{lm}(fit, formula)
}
\arguments{
\item{fit}{model fit with \code{lm} or \code{lmer}}

\item{formula}{formula of fixed and random effects to predict}
}
\value{
Predicted values from formula using parameter estimates from fit linear (mixed) model
}
\description{
Compute predicted value of formula for linear (mixed) model for with \code{lm} or \code{lmer}
}
\details{
Similar motivation as \code{lme4:::predict.merMod()}, but that function cannot use just a subset of the fixed effects: it either uses none or all.  Note that the intercept is included in the formula by default.  To exclude it from the prediction use \code{~ 0 + ...} syntax
}
\examples{

library(lme4)

# Linear model
fit <- lm(Reaction ~ Days, sleepstudy)

# prediction of intercept
get_prediction(fit, ~1)

# prediction of Days without intercept
get_prediction(fit, ~ 0 + Days)

# Linear mixed model

# fit model
fm1 <- lmer(Reaction ~ Days + (Days | Subject), sleepstudy)

# predict Days, but exclude intercept
get_prediction(fm1, ~ 0 + Days)

# predict Days and (Days | Subject) random effect, but exclude intercept
get_prediction(fm1, ~ 0 + Days + (Days | Subject))

}
