% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_motifs.R
\name{write_motifs}
\alias{write_motifs}
\title{Export motifs in universalmotif format.}
\usage{
write_motifs(motifs, file, minimal = FALSE, multifreq = TRUE,
  progress = FALSE, overwrite = FALSE, append = FALSE, BP = FALSE)
}
\arguments{
\item{motifs}{See \code{\link[=convert_motifs]{convert_motifs()}} for acceptable formats.}

\item{file}{\code{character(1)} File name.}

\item{minimal}{\code{logical(1)} Only write essential motif information.}

\item{multifreq}{\code{logical(1)} Write \code{multifreq} slot, if present.}

\item{progress}{\code{logical(1)} Show progress.}

\item{overwrite}{\code{logical(1)} Overwrite existing file.}

\item{append}{\code{logical(1)} Add to an existing motif file. Package version
in existing motif file must be greater than 1.2.0.}

\item{BP}{\code{logical(1)} Allows for the use of \pkg{BiocParallel} within
\code{\link[=write_motifs]{write_motifs()}}. See \code{\link[BiocParallel:register]{BiocParallel::register()}} to change the
default backend.}
}
\value{
\code{NULL}, invisibly.
}
\description{
Write motifs as universalmotif objects to file. For optimal storage of
\code{universalmotif} class motifs, consider using \code{\link[=saveRDS]{saveRDS()}} and
\code{\link[=readRDS]{readRDS()}}. Currently the \code{universalmotif} format is YAML-based, but
this is subject to change.
}
\seealso{
Other write_motifs: 
\code{\link{write_homer}()},
\code{\link{write_jaspar}()},
\code{\link{write_matrix}()},
\code{\link{write_meme}()},
\code{\link{write_transfac}()}
}
\author{
Benjamin Jean-Marie Tremblay, \email{benjamin.tremblay@uwaterloo.ca}
}
\concept{write_motifs}
