% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_homer.R
\name{read_homer}
\alias{read_homer}
\title{Import HOMER motifs.}
\usage{
read_homer(file, skip = 0)
}
\arguments{
\item{file}{\code{character(1)} File name.}

\item{skip}{\code{numeric(1)} If not zero, will skip however many desired lines in the
file before starting to read.}
}
\value{
\code{list} \linkS4class{universalmotif} objects.
}
\description{
Import HOMER formatted motifs. See \url{http://homer.ucsd.edu/homer/motif/}.
Assumed to be DNA motifs. Note that HOMER motifs come with a pre-determined
logodds threshold; if you wish to re-create HOMER's motif scanning, then use
it in \code{\link[=scan_sequences]{scan_sequences()}} (see examples).
}
\examples{
data(ArabidopsisPromoters)
homer <- read_homer(system.file("extdata", "homer.txt",
                                package = "universalmotif"))
thresholds <- homer |> to_df() |> with(logodds.threshold) |> as.numeric()
scan_sequences(homer, ArabidopsisPromoters,
  threshold = thresholds, threshold.type = "logodds.abs")

}
\references{
Heinz S, Benner C, Spann N, Bertolino E, Lin YC, Laslo P, Cheng
JX, Murre C, Singh H, Glass CK (2010). “Simple combinations of
lineage-determining transcription factors prime cis-regulatory
elements required for macrophage and B cell identities.”
\emph{Molecular Cell}, \strong{38}, 576-589.
}
\seealso{
Other read_motifs: 
\code{\link{read_cisbp}()},
\code{\link{read_jaspar}()},
\code{\link{read_matrix}()},
\code{\link{read_meme}()},
\code{\link{read_motifs}()},
\code{\link{read_transfac}()},
\code{\link{read_uniprobe}()}
}
\author{
Benjamin Jean-Marie Tremblay, \email{benjamin.tremblay@uwaterloo.ca}
}
\concept{read_motifs}
