% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert_motifs.R
\name{convert_motifs}
\alias{convert_motifs}
\alias{convert_motifs,AsIs-method}
\alias{convert_motifs,list-method}
\alias{convert_motifs,universalmotif-method}
\alias{convert_motifs,MotifList-method}
\alias{convert_motifs,TFFMFirst-method}
\alias{convert_motifs,PFMatrix-method}
\alias{convert_motifs,PWMatrix-method}
\alias{convert_motifs,ICMatrix-method}
\alias{convert_motifs,XMatrixList-method}
\alias{convert_motifs,pwm-method}
\alias{convert_motifs,pcm-method}
\alias{convert_motifs,pfm-method}
\alias{convert_motifs,PWM-method}
\alias{convert_motifs,Motif-method}
\alias{convert_motifs,matrix-method}
\title{Convert motif class.}
\usage{
convert_motifs(motifs, class = "universalmotif-universalmotif")

\S4method{convert_motifs}{AsIs}(motifs,
  class = "universalmotif-universalmotif")

\S4method{convert_motifs}{list}(motifs,
  class = "universalmotif-universalmotif")

\S4method{convert_motifs}{universalmotif}(motifs,
  class = "universalmotif-universalmotif")

\S4method{convert_motifs}{MotifList}(motifs,
  class = "universalmotif-universalmotif")

\S4method{convert_motifs}{TFFMFirst}(motifs,
  class = "universalmotif-universalmotif")

\S4method{convert_motifs}{PFMatrix}(motifs,
  class = "universalmotif-universalmotif")

\S4method{convert_motifs}{PWMatrix}(motifs,
  class = "universalmotif-universalmotif")

\S4method{convert_motifs}{ICMatrix}(motifs,
  class = "universalmotif-universalmotif")

\S4method{convert_motifs}{XMatrixList}(motifs,
  class = "universalmotif-universalmotif")

\S4method{convert_motifs}{pwm}(motifs,
  class = "universalmotif-universalmotif")

\S4method{convert_motifs}{pcm}(motifs,
  class = "universalmotif-universalmotif")

\S4method{convert_motifs}{pfm}(motifs,
  class = "universalmotif-universalmotif")

\S4method{convert_motifs}{PWM}(motifs,
  class = "universalmotif-universalmotif")

\S4method{convert_motifs}{Motif}(motifs,
  class = "universalmotif-universalmotif")

\S4method{convert_motifs}{matrix}(motifs,
  class = "universalmotif-universalmotif")
}
\arguments{
\item{motifs}{Single motif object or list. See details.}

\item{class}{\code{character(1)} Desired motif class. Input as
'package-class'. If left empty, defaults to
'universalmotif-universalmotif'. (See details.)}
}
\value{
Single motif object or list.
}
\description{
Allows for easy transfer of motif information between different classes as
defined by other Bioconductor packages. This function is also used by
nearly all other functions in this package, so any motifs of a compatible
class can be used without needing to be converted beforehand.
}
\details{
\subsection{Input}{

The following packge-class combinations can be used as input:
\itemize{
\item MotifDb-MotifList
\item TFBSTools-PFMatrix
\item TFBSTools-PWMatrix
\item TFBSTools-ICMatrix
\item TFBSTools-PFMatrixList
\item TFBSTools-PWMatrixList
\item TFBSTools-ICMatrixList
\item TFBSTools-TFFMFirst
\item seqLogo-pwm
\item motifStack-pcm
\item motifStack-pfm
\item PWMEnrich-PWM
\item motifRG-Motif
\item universalmotif-universalmotif
\item matrix
}
}

\subsection{Output}{

The following package-class combinations can be output:
\itemize{
\item MotifDb-MotifList
\item TFBSTools-PFMatrix
\item TFBSTools-PWMatrix
\item TFBSTools-ICMatrix
\item TFBSTools-TFFMFirst
\item seqLogo-pwm
\item motifStack-pcm
\item motifStack-pfm
\item PWMEnrich-PWM
\item Biostrings-PWM (\code{type = 'log2prob'})
\item rGADEM-motif
\item universalmotif-universalmotif (the default, no need to specify this)
}

Note: MotifDb-MotifList output was a later addition to \code{\link[=convert_motifs]{convert_motifs()}}.
As a result, to stay consistent with previous behaviour most functions
will always convert MotifDb-MotifList objects to a list of \code{universalmotif}
motifs, even if other formats would be simply returned as is (e.g. for
other formats, \code{\link[=filter_motifs]{filter_motifs()}} will return the input format; for
MotifDb-MotifList, a list of \code{universalmotif} objects will be returned).
}
}
\section{Methods (by class)}{
\itemize{
\item \code{convert_motifs(AsIs)}: Generate an error to remind users to run
\code{\link[=to_list]{to_list()}} instead of using the column from \code{\link[=to_df]{to_df()}} directly.

\item \code{convert_motifs(list)}: Convert a list of motifs.

\item \code{convert_motifs(universalmotif)}: Convert a \linkS4class{universalmotif} object.

\item \code{convert_motifs(MotifList)}: Convert MotifList motifs. (\pkg{MotifDb})

\item \code{convert_motifs(TFFMFirst)}: Convert TFFMFirst motifs. (\pkg{TFBSTools})

\item \code{convert_motifs(PFMatrix)}: Convert PFMatrix motifs. (\pkg{TFBSTools})

\item \code{convert_motifs(PWMatrix)}: Convert PWMatrix motifs. (\pkg{TFBSTools})

\item \code{convert_motifs(ICMatrix)}: Convert ICMatrix motifs. (\pkg{TFBSTools})

\item \code{convert_motifs(XMatrixList)}: Convert XMatrixList motifs. (\pkg{TFBSTools})

\item \code{convert_motifs(pwm)}: Convert pwm motifs. (\pkg{seqLogo})

\item \code{convert_motifs(pcm)}: Convert pcm motifs. (\pkg{motifStack})

\item \code{convert_motifs(pfm)}: Convert pfm motifs. (\pkg{motifStack})

\item \code{convert_motifs(PWM)}: Convert PWM motifs. (\pkg{PWMEnrich})

\item \code{convert_motifs(Motif)}: Convert Motif motifs. (\pkg{motifRG})

\item \code{convert_motifs(matrix)}: Create motif from matrices.

}}
\examples{
# Convert from universalmotif:
jaspar <- read_jaspar(system.file("extdata", "jaspar.txt",
                                  package = "universalmotif"))
if (requireNamespace("motifStack", quietly = TRUE)) {
  jaspar.motifstack.pfm <- convert_motifs(jaspar, "motifStack-pfm")
}

# Convert from another class to universalmotif:
if (requireNamespace("TFBSTools", quietly = TRUE)) {
library(TFBSTools)
data(MA0003.2)
motif <- convert_motifs(MA0003.2)

# Convert from another class to another class
if (requireNamespace("PWMEnrich", quietly = TRUE)) {
  motif <- convert_motifs(MA0003.2, "PWMEnrich-PWM")
}

# The 'convert_motifs' function is embedded in the rest of the universalmotif
# functions: non-universalmotif class motifs can be used
MA0003.2.trimmed <- trim_motifs(MA0003.2)
# Note: if the motif object going in has information that the
# 'universalmotif' class can't hold, it will be lost
}

}
\references{
Bembom O (2018). \emph{seqLogo: Sequence logos for DNA sequence
alignments}. R package version 1.46.0.

Droit A, Gottardo R, Robertson G, Li L (2014). \emph{rGADEM: de novo
motif discovery}. R package version 2.28.0.

Mercier E, Gottardo R (2014). \emph{MotIV: Motif Identification and
Validation}. R package version 1.36.0.

Ou J, Wolfe SA, Brodsky MH, Zhu LJ (2018). “motifStack for the
analysis of transcription factor binding site evolution.” \emph{Nature
Methods}, \strong{15}, 8-9. doi: 10.1038/nmeth.4555.

Shannon P, Richards M (2018). \emph{MotifDb: An Annotated Collection of
Protein-DNA Binding Sequence Motifs}. R package version 1.22.0.

Stojnic R, Diez D (2015). \emph{PWMEnrich: PWM enrichment analysis}. R
package version 4.16.0.

Tan G, Lenhard B (2016). “TFBSTools: an R/Bioconductor package for
transcription factor binding site analysis.” \emph{Bioinformatics},
\strong{32}, 1555-1556. doi: 10.1093/bioinformatics/btw024.

Yao Z (2012). \emph{motifRG: A package for discriminative motif
discovery, designed for high throughput sequencing dataset}. R
package version 1.24.0.
}
\author{
Benjamin Jean-Marie Tremblay, \email{benjamin.tremblay@uwaterloo.ca}
}
