% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mixed_reference.R
\name{updateMetadata}
\alias{updateMetadata}
\title{Update transcript metadatda for \code{importData()} imported data}
\usage{
updateMetadata(
  se,
  txpData = NULL,
  ranges = FALSE,
  prefer = c("txome", "txpdata", "precomputed"),
  order = c("annotated", "novel", "user"),
  key = c(annotated = "tx_name", novel = "tx_name", user = "tx_name")
)
}
\arguments{
\item{se}{the \emph{SummarizedExperiment} (SE) output by \code{importData()}}

\item{txpData}{either \emph{GRanges} or \emph{data.frame}-type object
to use if there is not a match based on digest.
This is used on a one-time basis, and transcripts
will be marked in metadata columns as \verb{index = "user"``. See }makeLinkedTxome()\code{or}makeLinkedTxpData()` for persistent
metadata storage/retrieval}

\item{ranges}{logical, whether to add \code{rowRanges} (or just \code{rowData})}

\item{prefer}{vector of length up to 3, giving the preferred order of
\emph{tximeta}'s transcript registries to when finding matches, with elements:
\code{txome}: linkedTxome,
\code{txpdata}: linkedTxpData,
\code{precomputed}: the pre-computed digests in tximeta}

\item{order}{order of index, in which to update the metadata, by default
the order is \code{annotation}, then \code{novel}, then \code{user}, info supplied
here as \code{txpData}}

\item{key}{a named character vector of length 3. For each index
(annotated, novel, and user) \code{key} is the name of the column to
use for merging metadata with \code{rownames(se)}.
The \code{user} index corresponds to data provided here as \code{txpData}
Defaults to \code{"tx_name"} which often matches the transcript
names in GENCODE}
}
\value{
a \emph{SummarizedExperiment} with new \code{rowData},
or a \emph{RangedSummarizedExperiment} with new metadata
}
\description{
This function takes as input a \emph{SummarizedExperiment} as output by \code{importData()},
and will update the metadata on the transcripts when possible
(updating \code{rowData} and/or \code{rowRanges} depending on the value of \code{ranges}).
\code{importData()} uses metadata pulled from digest matches in registries used by \emph{tximeta}
(\code{linkedTxome}, \code{linkedTxpData}, and the pre-computed digests).
Additionally, \emph{GRanges} or \emph{data.frame}-type data can be provided on a one-time basis
via the argument \code{txpData}, which will annotate transcripts with \code{index="user"}.
See \code{inspectDigests()} for how to inspect which indices have matching digests,
and how to link data to local metadata in a persistent manner.
}
\examples{

example(importData)

# build custom novel GRanges data
library(GenomicRanges)
novel <- data.frame(
  seqnames = paste0("chr", rep(1:22, each=500)),  
  start = 1e6 + 1 + 0:499 * 1000, end = 1e6 + 1 + 0:499 * 1000 + 1000 - 1,
  strand = "+", tx_name = paste0("novel", 1:(22*500)),
  gene_id = paste0("novel_gene", rep(1:(22*10), each=50)), type = "protein_coding"
)
novel_gr <- as(novel, "GRanges")
names(novel_gr) <- novel$tx_name

# now update the metadata + ranges:
\dontrun{
# this requires connection to internet (will download GENCODE GTF via FTP)
se_with_ranges <- updateMetadata(
  se, txpData=novel_gr, ranges=TRUE
)
mcols(se_with_ranges)
}

}
