% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ASTRAL.R
\name{read.astral}
\alias{read.astral}
\title{read.astral}
\usage{
read.astral(file)
}
\arguments{
\item{file}{ASTRAL Newick file}
}
\value{
treedata object
}
\description{
parse ASTRAL output newick text
}
\examples{
tt <- paste0(
  "((species1,(species2,species3)'[pp1=0.75;pp2=0.24;pp3=0.01]':",
  "1.2003685744180805)'[pp1=0.98;pp2=0.02;pp3=0]':0.9679599282730038,",
  "((species4,species5)'[pp1=0.88;pp2=0.11;pp3=0.01]':1.2454851536484994))"
)
read.astral(textConnection(tt))
}
\author{
Guangchuang Yu
}
