% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tpr.R
\name{tpr}
\alias{tpr}
\title{Calculate true positive rate (TPR) on a tree structure}
\usage{
tpr(tree, truth, found, only.leaf = TRUE)
}
\arguments{
\item{tree}{A \code{phylo} object.}

\item{truth}{True signal nodes (e.g., nodes that are truly differentially
abundant between experimental conditions). \strong{Note:} when the
TPR is requested at the leaf level (\code{only.leaf = TRUE}), the
descendant leaves of the given nodes will be found and the TPR will be
estimated on the leaf level.}

\item{found}{Detected signal nodes (e.g., nodes that have been found to be
differentially abundant via a statistical testing procedure).
\strong{Note:} when the TPR is requested at the leaf level
(\code{only.leaf = TRUE}), the descendant leaves of the given nodes will
be found out and the TPR will be estimated on the leaf level.}

\item{only.leaf}{A logical scalar. If \code{TRUE}, the false discovery rate
is calculated at the leaf (tip) level; otherwise it is calculated at
the node level.}
}
\value{
The estimated true positive rate.
}
\description{
Calculate the true positive rate on a tree structure, at either leaf or
node level.
}
\examples{
suppressPackageStartupMessages({
    library(ggtree)
    library(TreeSummarizedExperiment)
})

data("tinyTree")

## Two branches are truly differential
ggtree(tinyTree, branch.length = "none") +
   geom_text2(aes(label = node)) +
   geom_hilight(node = 16, fill = "orange", alpha = 0.3) +
   geom_hilight(node = 13, fill = "blue", alpha = 0.3)

## TPR at the leaf level if nodes 14 and 15 are called differential  (7/8)
tpr(tree = tinyTree, truth = c(16, 13),
    found = c(15, 14), only.leaf = TRUE)

## TPR at the node level if nodes 14 and 15 are called differential (12/14)
tpr(tree = tinyTree, truth = c(16, 13),
    found = c(15, 14), only.leaf = FALSE)

}
\author{
Ruizhu Huang
}
