% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{calculate_local_consistency}
\alias{calculate_local_consistency}
\title{Local Consistency Score}
\usage{
calculate_local_consistency(x, numPermutations, minPermutations, e)
}
\arguments{
\item{x}{numeric vector that contains values for shuffling}

\item{numPermutations}{maximum number of permutations performed in
Monte Carlo test
for consistency score}

\item{minPermutations}{minimum number of permutations performed in
Monte Carlo test
for consistency score}

\item{e}{stop criterion for consistency score Monte Carlo test:
aborting permutation
process after observing \code{e} random consistency values with
more extreme values
than the actual consistency value}
}
\value{
list with \code{score}, \code{p_value}, and \code{n} components,
where \code{score} is the raw local consistency score (usually not used),
\code{p_value} is the associated p-value for that score, obtained by
Monte Carlo testing, and \code{n} is the number of permutations performed
in the Monte Carlo test (the higher, the more significant)
}
\description{
C++ implementation of Local Consistency Score algorithm.
}
\examples{
poor_enrichment_spectrum <- c(0.1, 0.5, 0.6, 0.4,
  0.7, 0.6, 1.2, 1.1, 1.8, 1.6)
local_consistency <- calculate_local_consistency(poor_enrichment_spectrum,
  1000000, 1000, 5)

enrichment_spectrum <- c(0.1, 0.3, 0.6, 0.7, 0.8,
  0.9, 1.2, 1.4, 1.6, 1.4)
local_consistency <- calculate_local_consistency(enrichment_spectrum,
  1000000, 1000, 5)
}
