% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/AllMethods.R
\docType{methods}
\name{connectivityProperties}
\alias{connectivityProperties}
\alias{connectivityProperties,Transcriptogram-method}
\alias{connectivityProperties-method}
\title{Calculates average graph properties as function of node connectivity}
\usage{
connectivityProperties(object)

\S4method{connectivityProperties}{Transcriptogram}(object)
}
\arguments{
\item{object}{An object of class Transcriptogram.}
}
\value{
This method returns a data.frame containing: unique degrees (k) of
the nodes of the graph,
probability (pk) of a node of the graph has degree k, average assortativity
(ak) of the nodes of degree
k, and the average clustering coefficient (ck) of the nodes of degree k.
}
\description{
Calculates network properties as function of node connectivity/degree (k),
such as: probability of a protein of the graph has degree k, average
assortativity of the nodes of degree k, and the average clustering
coefficient of the nodes of degree k.
}
\details{
The assortativity of a node can be measured by the average degree of its
neighbors.
}
\examples{
transcriptogram <- transcriptogramPreprocess(association, Hs900)
\dontrun{
cProperties <- connectivityProperties(transcriptogram)
}

}
\seealso{
\link[transcriptogramer]{transcriptogramPreprocess},
\link[transcriptogramer]{Hs900},
\link[transcriptogramer]{association}
}
\author{
Diego Morais
}
