% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ChipDataSet-generics.R, R/ChipDataSet-methods.R
\docType{methods}
\name{peaksToBed}
\alias{peaksToBed}
\alias{peaksToBed,ChipDataSet-method}
\title{peaksToBed}
\usage{
peaksToBed(
  object,
  file,
  strand.pred.color = c("blue", "red", "green4", "black"),
  gene.associated.peaks = TRUE
)

\S4method{peaksToBed}{ChipDataSet}(
  object,
  file,
  strand.pred.color = c("blue", "red", "green4", "black"),
  gene.associated.peaks = TRUE
)
}
\arguments{
\item{object}{A \code{\link{ChipDataSet}} object.}

\item{file}{\code{Character}. A file name.}

\item{strand.pred.color}{\code{Character}. A vector of length four, specifying
colors of the predicted peak strand. The order of colors corresponds
to 1) plus strand, 2) minus strand, 3) bideractional, 4) strand not
determined. Default: c("blue", "red", "green4", "black").}

\item{gene.associated.peaks}{\code{Logical}. Whether to return gene
associated peaks (based on the prediction) only. Default: TRUE}
}
\value{
A file in the BED format.
}
\description{
A convenient way to explore output of the predictions made on the ChIP peaks
is to visualize them in the
\href{https://genome.ucsc.edu/}{UCSC genome browser}. The peaksToBed function
returns a file in
\href{https://genome.ucsc.edu/FAQ/FAQformat.html#format1}{BED} format, which
can be uploaded directly to the genome browser. To improve the visual
perception, peaks are color-coded by the predicted strand.
}
\examples{
### Load ChipDataSet object
data(cds)

### Load TranscriptionDataSet object
data(tds)

### Classify peaks on gene associated and background
predictTssOverlap(object = cds, feature = "pileup", p = 0.75)

### Predict peak 'strandedness'
predictStrand(cdsObj = cds, tdsObj = tds, coverage.cutoff = 5,
quant.cutoff = 0.1, win.size = 2500)

# peaksToBed(object = cds, file = "peaks.bed", gene.associated.peaks = TRUE)

}
\seealso{
\code{\link{constructCDS}}
    \code{\link{predictTssOverlap}}
    \code{\link{predictStrand}}
    \href{https://genome.ucsc.edu/}{UCSC genome browser}
    \href{https://genome.ucsc.edu/FAQ/FAQformat.html#format1}{BED}
}
\author{
Armen R. Karapetyan
}
