% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TranscriptionDataSet-methods.R
\name{constructTDS}
\alias{constructTDS}
\title{constructTDS}
\usage{
constructTDS(file, region, fragment.size = 250, unique = FALSE,
  paired.end = FALSE, swap.strand = FALSE, param = NULL)
}
\arguments{
\item{file}{A path to a BAM file with sequencing reads.}

\item{region}{\code{\link[GenomicRanges]{GRanges}}. Genomic region(s) to
extract reads from. If not supplied, all the reads from a BAM file are
extracted.}

\item{fragment.size}{\code{Numeric}. Extend read length to the fragment size.
Default: 250.}

\item{unique}{\code{Logical}. Whether to remove duplicated reads (based on the
genomic coordinates). Default: FALSE.}

\item{paired.end}{\code{Logical}. Whether to treat a BAM file as paired-end.
Default: FALSE.}

\item{swap.strand}{\code{Logical}. Whether to reverse the strand of the read.
Default: FALSE.}

\item{param}{\code{\link[Rsamtools]{ScanBamParam}} object influencing what
fields and which records (reads) are imported from a BAM file. Default:
NULL.}
}
\value{
An object of class \code{\link{TranscriptionDataSet}}.
}
\description{
The function constructs an object of class \code{\link{TranscriptionDataSet}},
which is a container for holding processed sequencing data and the results of
all downstream analyses. All the slots of the created object are filled
during the workflow by applying specific functions to the object directly.
}
\details{
The slots \code{fragments}, \code{fragmentSize}, \code{region},
    \code{coveragePlus}, \code{coverageMinus} are filled during the object
    construction. The \code{fragments} holds information about genomic
    coordinates of the sequenced fragments (reads extended to the fragmento
    size). \code{coveragePlus} and \code{coverageMinus} for each position in
    the genome counts the number of fragments that cover it (for the details,
    see \code{\link[IRanges]{coverage}}). \code{region} holds information about
    the region used for fragments extraction.
}
\examples{
### Load TranscriptionDataSet object
data(tds)

### View a short summary of the object
tds

}
\author{
Armen R. Karapetyan
}

