% Generated by roxygen2 (4.0.1): do not edit by hand
\docType{methods}
\name{MakeIGVSessionXML}
\alias{MakeIGVSessionXML}
\title{Make IGV session XML}
\usage{
MakeIGVSessionXML(fileSheet, igvdirectory, XMLname, genomeName,
  locusName = "All", colourBy = NULL, igvParams = igvParam())
}
\arguments{
\item{fileSheet}{A data.frame of file locations. First column must contain the unique sample ids.}

\item{igvdirectory}{A character of the directory to which IGV XML session is written.}

\item{XMLname}{A character of the name for IGV session xml}

\item{genomeName}{A character of genome for IGV (See IGV user guide for details)}

\item{locusName}{A character of locus to display in igv on loading (See IGV user guide for details)}

\item{colourBy}{Character vector of RGB colours to use for colouring displayed BigWigs}

\item{igvParams}{An object of class igvParam containing display parameters for IGV.
When providing a list, this list must be same length as number of samples and each element have two numeric values corresponding to minimum
and maximum value to be used in setting data range. Currently only "autoscale" or a list of minimum and maximum values are accepted.}
}
\value{
A character of file location for the IGV session XML
}
\description{
Creates session XML for IGV from a FileSheet of file locations.
}
\examples{
fileLocations <- system.file("extdata",package="tracktables")

bigwigs <- dir(fileLocations,pattern="*.bw",full.names=TRUE)

intervals <- dir(fileLocations,pattern="*.bed",full.names=TRUE)

bigWigMat <- cbind(gsub("_Example.bw","",basename(bigwigs)),
                   bigwigs)

intervalsMat <- cbind(gsub("_Peaks.bed","",basename(intervals)),
                      intervals)

fileSheet <- merge(bigWigMat,intervalsMat,all=TRUE)

fileSheet <- as.matrix(cbind(fileSheet,NA))

colnames(fileSheet) <- c("SampleName","bigwig","interval","bam")

MakeIGVSessionXML(fileSheet,igvdirectory=getwd(),"Example","mm9")
}
\author{
Thomas Carroll
}

