% Generated by roxygen2 (4.0.1): do not edit by hand
\docType{methods}
\name{MakeIGVSampleMetadata}
\alias{MakeIGVSampleMetadata}
\title{Make sample metadata file for use with IGV.}
\usage{
MakeIGVSampleMetadata(SampleSheet, fileSheet, igvdirectory)
}
\arguments{
\item{SampleSheet}{A data.frame object with metadata information for samples.
First column must contain unique sample ids.}

\item{fileSheet}{A data.frame of file locations. First column must contain the unique sample ids.}

\item{igvdirectory}{A character of the directory to which sample metadata file is written.}
}
\value{
A character of file location for the IGV sample information file.
}
\description{
Creates sample metadata file for IGV from a Samplesheet of metadata and FileSheet of file locations.
}
\examples{
fileLocations <- system.file("extdata",package="tracktables")

bigwigs <- dir(fileLocations,pattern="*.bw",full.names=TRUE)

intervals <- dir(fileLocations,pattern="*.bed",full.names=TRUE)

bigWigMat <- cbind(gsub("_Example.bw","",basename(bigwigs)),
                   bigwigs)

intervalsMat <- cbind(gsub("_Peaks.bed","",basename(intervals)),
                      intervals)

fileSheet <- merge(bigWigMat,intervalsMat,all=TRUE)

fileSheet <- as.matrix(cbind(fileSheet,NA))

colnames(fileSheet) <- c("SampleName","bigwig","interval","bam")

SampleSheet <- cbind(as.vector(fileSheet[,"SampleName"]),
                     c("EBF","H3K4me3","H3K9ac","RNAPol2"),
                     c("ProB","ProB","ProB","ProB"))

colnames(SampleSheet) <- c("SampleName","Antibody","Species")
MakeIGVSampleMetadata(SampleSheet,fileSheet,igvdirectory=getwd())
}
\author{
Thomas Carroll
}

