% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allclasses.R
\docType{class}
\name{trackViewerStyle-class}
\alias{trackViewerStyle-class}
\alias{trackViewerStyle}
\alias{setTrackViewerStyleParam}
\alias{setTrackViewerStyleParam,trackViewerStyle,character-method}
\alias{setTrackViewerStyleParam,trackViewerStyle,character,ANY-method}
\title{Class \code{"trackViewerStyle"}}
\usage{
trackViewerStyle(...)

setTrackViewerStyleParam(tvs, attr, value)

\S4method{setTrackViewerStyleParam}{trackViewerStyle,character}(tvs, attr, value)
}
\arguments{
\item{\dots}{Each argument in \dots becomes an slot in the new trackViewerStyle.}

\item{tvs}{An object of \code{trackViewerStyle}.}

\item{attr}{the name of slot to be changed.}

\item{value}{values to be assigned.}
}
\description{
An object of class \code{"trackViewerStyle"} 
             represents track viewer style.
}
\section{Slots}{

\describe{
\item{\code{margin}}{\code{"numeric"}, specify the bottom, left, top and right margin.}

\item{\code{xlas}}{\code{"numeric"}, label direction of x-axis mark. It should 
be a integer 0-3. See \code{\link[graphics]{par}:las}}

\item{\code{xgp}}{A \code{"list"}, object, It will convert to an object of 
class \code{\link[grid]{gpar}}. This is basically a list of graphical 
parameter settings of x-axis. For y-axis, see \code{\link{yaxisStyle}}}

\item{\code{xaxis}}{\code{"logical"}, draw x-axis or not}

\item{\code{xat}}{\code{"numeric"}, the values will be passed to grid.xaxis as
'at' parameter.}

\item{\code{xlabel}}{\code{"character"}, the values will be passed to grid.xaxis as
'label' parameter.}

\item{\code{autolas}}{\code{"logical"} automatic determine y label direction}

\item{\code{flip}}{\code{"logical"} flip the x-axis or not, default FALSE}
}}

\examples{
tvs <- trackViewerStyle()
setTrackViewerStyleParam(tvs, "xaxis", TRUE)

}
