% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggplot.R
\name{scale_x_log10_reverse}
\alias{scale_x_log10_reverse}
\title{scale_x_log10_reverse}
\usage{
scale_x_log10_reverse(breaks = 5, digits = 2, ...)
}
\arguments{
\item{breaks}{Number of breaks to display (default: 5)}

\item{digits}{Number of digits for scientific notation (default: 2)}

\item{...}{Additional arguments passed to scale_x_continuous}
}
\value{
A ggplot2 scale object
}
\description{
A wrapper function that provides evenly spaced ticks with scientific notation for log10 reverse transformed x-axis. This is particularly useful for plots showing p-values or other values where smaller values should be displayed larger. The function applies a log10 transformation and reverses the axis to better visualize p-values without hard transforming the data, while maintaining the original p-value scale for interpretation. This allows you to see the full range of p-values with proper scaling while keeping the original values readable.
}
\details{
`r lifecycle::badge("maturing")`
}
\examples{

library(ggplot2)
library(tibble)

# Create test data
test_data <- tibble(
  pvalue = c(0.0001, 0.001, 0.01, 0.05, 0.1, 0.5),
  fold_change = 1:6
)

# Use the wrapper function
test_data |>
  ggplot(aes(pvalue, fold_change)) +
  geom_point() +
  scale_x_log10_reverse()

}
\references{
Mangiola, S., Molania, R., Dong, R., Doyle, M. A., & Papenfuss, A. T. (2021). tidybulk: an R tidy framework for modular transcriptomic data analysis. Genome Biology, 22(1), 42. doi:10.1186/s13059-020-02233-7

Wickham, H. (2016). ggplot2: Elegant Graphics for Data Analysis. Springer-Verlag New York. https://ggplot2.tidyverse.org
}
