% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pivot.R
\docType{methods}
\name{pivot_transcript}
\alias{pivot_transcript}
\alias{pivot_transcript,SummarizedExperiment-method}
\alias{pivot_transcript,RangedSummarizedExperiment-method}
\title{Extract transcript-wise information}
\usage{
pivot_transcript(.data)

\S4method{pivot_transcript}{SummarizedExperiment}(.data)

\S4method{pivot_transcript}{RangedSummarizedExperiment}(.data)
}
\arguments{
\item{.data}{A `tbl` (with at least three columns for sample, feature and transcript abundance) or `SummarizedExperiment` (more convenient if abstracted to tibble with library(tidySummarizedExperiment))}
}
\value{
A `tbl` with transcript-related information

A consistent object (to the input)

A consistent object (to the input)
}
\description{
pivot_transcript() takes as input a `tbl` (with at least three columns for sample, feature and transcript abundance) or `SummarizedExperiment` (more convenient if abstracted to tibble with library(tidySummarizedExperiment)) and returns a `tbl` with only transcript-related columns
}
\details{
`r lifecycle::badge("maturing")`

This functon extracts only transcript-related information for downstream analysis (e.g., visualisation). It is disruptive in the sense that it cannot be passed anymore to tidybulk function.
}
\examples{
## Load airway dataset for examples

  data('airway', package = 'airway')
  # Ensure a 'condition' column exists for examples expecting it

    SummarizedExperiment::colData(airway)$condition <- SummarizedExperiment::colData(airway)$dex


library(airway)
data(airway)
airway <- airway[1:100, 1:5]

	pivot_transcript(airway 	)

}
\references{
Mangiola, S., Molania, R., Dong, R., Doyle, M. A., & Papenfuss, A. T. (2021). tidybulk: an R tidy framework for modular transcriptomic data analysis. Genome Biology, 22(1), 42. doi:10.1186/s13059-020-02233-7
}
