% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pivot.R
\docType{methods}
\name{pivot_sample}
\alias{pivot_sample}
\alias{pivot_sample,SummarizedExperiment-method}
\alias{pivot_sample,RangedSummarizedExperiment-method}
\title{Extract sample-wise information}
\usage{
pivot_sample(.data)

\S4method{pivot_sample}{SummarizedExperiment}(.data)

\S4method{pivot_sample}{RangedSummarizedExperiment}(.data)
}
\arguments{
\item{.data}{A `tbl` (with at least three columns for sample, feature and transcript abundance) or `SummarizedExperiment` (more convenient if abstracted to tibble with library(tidySummarizedExperiment))}
}
\value{
A `tbl` with transcript-related information

A consistent object (to the input)

A consistent object (to the input)
}
\description{
pivot_sample() takes as input a `tbl` (with at least three columns for sample, feature and transcript abundance) or `SummarizedExperiment` (more convenient if abstracted to tibble with library(tidySummarizedExperiment)) and returns a `tbl` with only sample-related columns
}
\details{
`r lifecycle::badge("maturing")`

This functon extracts only sample-related information for downstream analysis (e.g., visualisation). It is disruptive in the sense that it cannot be passed anymore to tidybulk function.
}
\examples{
## Load airway dataset for examples

  data('airway', package = 'airway')
  # Ensure a 'condition' column exists for examples expecting it

    SummarizedExperiment::colData(airway)$condition <- SummarizedExperiment::colData(airway)$dex


library(airway)
data(airway)
airway <- airway[1:100, 1:5]

	pivot_sample(airway )


}
