% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidyr_methods.R
\name{nest}
\alias{nest}
\alias{nest.SingleCellExperiment}
\title{Nest rows into a list-column of data frames}
\usage{
\method{nest}{SingleCellExperiment}(.data, ..., .names_sep = NULL)
}
\arguments{
\item{.data}{A data frame.}

\item{...}{<\code{\link[tidyr:tidyr_tidy_select]{tidy-select}}> Columns to nest; these will
appear in the inner data frames.

Specified using name-variable pairs of the form
\code{new_col = c(col1, col2, col3)}. The right hand side can be any valid
tidyselect expression.

If not supplied, then \code{...} is derived as all columns \emph{not} selected by
\code{.by}, and will use the column name from \code{.key}.

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}:
previously you could write \code{df \%>\% nest(x, y, z)}.
Convert to \code{df \%>\% nest(data = c(x, y, z))}.}

\item{.names_sep}{If \code{NULL}, the default, the inner names will come from
the former outer names. If a string, the  new inner names will use the
outer names with \code{names_sep} automatically stripped. This makes
\code{names_sep} roughly symmetric between nesting and unnesting.}
}
\value{
`tidySingleCellExperiment_nested`
}
\description{
Nesting creates a list-column of data frames; unnesting flattens it back out
into regular columns. Nesting is implicitly a summarising operation: you
get one row for each group defined by the non-nested columns. This is useful
in conjunction with other summaries that work with whole datasets, most
notably models.

Learn more in \code{vignette("nest")}.
}
\details{
If neither \code{...} nor \code{.by} are supplied, \code{nest()} will nest all variables,
and will use the column name supplied through \code{.key}.
}
\section{New syntax}{


tidyr 1.0.0 introduced a new syntax for \code{nest()} and \code{unnest()} that's
designed to be more similar to other functions. Converting to the new syntax
should be straightforward (guided by the message you'll receive) but if
you just need to run an old analysis, you can easily revert to the previous
behaviour using \code{\link[tidyr:nest_legacy]{nest_legacy()}} and \code{\link[tidyr:unnest_legacy]{unnest_legacy()}} as follows:

\if{html}{\out{<div class="sourceCode">}}\preformatted{library(tidyr)
nest <- nest_legacy
unnest <- unnest_legacy
}\if{html}{\out{</div>}}

}

\section{Grouped data frames}{


\code{df \%>\% nest(data = c(x, y))} specifies the columns to be nested; i.e. the
columns that will appear in the inner data frame. \code{df \%>\% nest(.by = c(x, y))} specifies the columns to nest \emph{by}; i.e. the columns that will remain in
the outer data frame. An alternative way to achieve the latter is to \code{nest()}
a grouped data frame created by \code{\link[dplyr:group_by]{dplyr::group_by()}}. The grouping variables
remain in the outer data frame and the others are nested. The result
preserves the grouping of the input.

Variables supplied to \code{nest()} will override grouping variables so that
\code{df \%>\% group_by(x, y) \%>\% nest(data = !z)} will be equivalent to
\code{df \%>\% nest(data = !z)}.

You can't supply \code{.by} with a grouped data frame, as the groups already
represent what you are nesting by.

}

\examples{
data(pbmc_small)
pbmc_small |>
    nest(data=-groups) |>
    unnest(data)

}
\references{
Hutchison, W.J., Keyes, T.J., The tidyomics Consortium. et al. The tidyomics ecosystem: enhancing omic data analyses. Nat Methods 21, 1166–1170 (2024). https://doi.org/10.1038/s41592-024-02299-2

Wickham H, Averick M, Bryan J, Chang W, McGowan LD, François R, et al. Welcome to the tidyverse. Journal of Open Source Software. 2019;4(43):1686. https://doi.org/10.21105/joss.01686
}
