% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tibble_methods.R
\name{glimpse}
\alias{glimpse}
\alias{glimpse.tidySingleCellExperiment}
\title{Get a glimpse of your data}
\usage{
\method{glimpse}{tidySingleCellExperiment}(x, width = NULL, ...)
}
\arguments{
\item{x}{An object to glimpse at.}

\item{width}{Width of output: defaults to the setting of the
\code{width} \link[pillar:pillar_options]{option} (if finite)
or the width of the console.}

\item{...}{Unused, for extensibility.}
}
\value{
x original x is (invisibly) returned, allowing \code{glimpse()} to be
used within a data pipe line.
}
\description{
\code{glimpse()} is like a transposed version of \code{print()}:
columns run down the page, and data runs across.
This makes it possible to see every column in a data frame.
It's a little like \code{\link[=str]{str()}} applied to a data frame
but it tries to show you as much data as possible.
(And it always shows the underlying data, even when applied
to a remote data source.)

See \code{\link[pillar:format_glimpse]{format_glimpse()}} for details on the formatting.
}
\section{S3 methods}{


\code{glimpse} is an S3 generic with a customised method for \code{tbl}s and
\code{data.frames}, and a default method that calls \code{\link[=str]{str()}}.

}

\examples{
data(pbmc_small)
pbmc_small |> glimpse()

}
\references{
Hutchison, W.J., Keyes, T.J., The tidyomics Consortium. et al. The tidyomics ecosystem: enhancing omic data analyses. Nat Methods 21, 1166–1170 (2024). https://doi.org/10.1038/s41592-024-02299-2

Wickham H, Averick M, Bryan J, Chang W, McGowan LD, François R, et al. Welcome to the tidyverse. Journal of Open Source Software. 2019;4(43):1686. https://doi.org/10.21105/joss.01686
}
