% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dplyr_verbs.R
\name{rename_with.flowFrame}
\alias{rename_with.flowFrame}
\title{Rename columns in a \code{\link[flowCore]{flowFrame}}}
\usage{
\method{rename_with}{flowFrame}(.data, .fn, .cols = dplyr::everything(), ...)
}
\arguments{
\item{.data}{A \code{\link[flowCore]{flowFrame}}}

\item{.fn}{A function used to transform the selected .cols.
Should return a character vector the same length as the input.}

\item{.cols}{Unquoted column names indicating which columns to rename
(as specified by \code{\link[flowCore]{featureNames}}).}

\item{...}{Additional arguments passed onto .fn.}
}
\value{
An object of the same type as .data. The output has the following properties:
* Rows are not affected.
* Column names are changed; column order is preserved.
* The \code{\link[flowCore]{flowFrame}}'s \code{\link[flowCore]{identifier}} will be preserved.
}
\description{
Rename columns in a \code{\link[flowCore]{flowFrame}}
}
\examples{

my_flowframe <- simulate_cytometry_data()$flowframe

 my_flowframe |>
   dplyr::rename_with(.fn = toupper)

}
