% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggplot2_verbs.R
\name{ggplot.flowFrame}
\alias{ggplot.flowFrame}
\title{Create a new ggplot.}
\usage{
\method{ggplot}{flowFrame}(
  data = NULL,
  mapping = ggplot2::aes(),
  ...,
  environment = parent.frame()
)
}
\arguments{
\item{data}{Default dataset to use for plot in the form of a
\code{\link[flowCore]{flowFrame}}. If not specified, must be supplied in each
 layer added to the plot.}

\item{mapping}{Default list of aesthetic mappings to use for plot.
If not specified, must be supplied in each layer added to the plot. Note that
variable names used for aesthetic mappings come from the
\code{\link[flowCore]{featureNames}} of the input \code{\link[flowCore]{flowFrame}}.}

\item{...}{Other arguments passed on to methods. Not currently used.}

\item{environment}{Deprecated. Used prior to tidy evaluation.}
}
\value{
A \code{\link[ggplot2]{ggplot}}
}
\description{
Create a new ggplot.
}
\examples{
simulations <- simulate_cytometry_data()
test_flowframe <- simulations$flowframe

flowframe_plot <-
  test_flowframe |>
  ggplot2::ggplot(ggplot2::aes(x = feature_1, y = feature_2)) +
  ggplot2::geom_point()

}
