% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/CoverageExperiment.R,
%   R/coarsen.R
\name{CoverageExperiment}
\alias{CoverageExperiment}
\alias{coarsen}
\alias{CoverageExperiment,BigWigFileList,GRangesList-method}
\alias{CoverageExperiment,BigWigFileList,GRanges-method}
\alias{CoverageExperiment,BigWigFileList,list-method}
\alias{CoverageExperiment,BigWigFile,GRangesList-method}
\alias{CoverageExperiment,BigWigFile,GRanges-method}
\alias{CoverageExperiment,BigWigFile,list-method}
\alias{CoverageExperiment,list,GRangesList-method}
\alias{CoverageExperiment,list,GRanges-method}
\alias{CoverageExperiment,list,list-method}
\alias{CoverageExperiment,RleList,GRangesList-method}
\alias{CoverageExperiment,RleList,GRanges-method}
\alias{CoverageExperiment,RleList,list-method}
\alias{coarsen,CoverageExperiment-method}
\title{CoverageExperiment}
\usage{
CoverageExperiment(tracks, features, ...)

coarsen(x, window, ...)

\S4method{CoverageExperiment}{BigWigFileList,GRangesList}(
  tracks,
  features,
  width = NULL,
  center = FALSE,
  scale = FALSE,
  ignore.strand = TRUE,
  window = 1,
  BPPARAM = BiocParallel::bpparam()
)

\S4method{CoverageExperiment}{BigWigFileList,GRanges}(tracks, features, ...)

\S4method{CoverageExperiment}{BigWigFileList,list}(tracks, features, ...)

\S4method{CoverageExperiment}{BigWigFile,GRangesList}(tracks, features, ...)

\S4method{CoverageExperiment}{BigWigFile,GRanges}(tracks, features, ...)

\S4method{CoverageExperiment}{BigWigFile,list}(tracks, features, ...)

\S4method{CoverageExperiment}{list,GRangesList}(
  tracks,
  features,
  width = NULL,
  center = FALSE,
  scale = FALSE,
  ignore.strand = TRUE,
  window = 1,
  BPPARAM = BiocParallel::bpparam()
)

\S4method{CoverageExperiment}{list,GRanges}(tracks, features, ...)

\S4method{CoverageExperiment}{list,list}(tracks, features, ...)

\S4method{CoverageExperiment}{RleList,GRangesList}(tracks, features, ...)

\S4method{CoverageExperiment}{RleList,GRanges}(tracks, features, ...)

\S4method{CoverageExperiment}{RleList,list}(tracks, features, ...)

\S4method{coarsen}{CoverageExperiment}(x, window = 1, BPPARAM = BiocParallel::bpparam())
}
\arguments{
\item{tracks}{A genomic track imported as a \code{RleList} or a \emph{named} list of
genomic tracks.}

\item{features}{A set of features imported as \code{GRanges} or a \emph{named}
\code{GRangesList}.}

\item{...}{Passed to the relevant method}

\item{x}{a \code{CoverageExperiment} object}

\item{window}{an integer to coarsen coverage by.}

\item{width}{Width to resize each set of genomic features}

\item{scale, center}{Logical, whether to scale and/or center tracks prior to
summarization}

\item{ignore.strand}{Logical, whether to not take the features strand
information}

\item{BPPARAM}{Passed to BiocParallel.}
}
\value{
A \code{CoverageExperiment} object
}
\description{
#' @description
}
\details{
\code{CoverageExperiment} objects store coverages for individual
tracks over different sets of features. The \code{coverage}
assay contains a separate matrix for each combination of
track x features. \code{CoverageExperiment} objects are instantiated
using the \code{CoverageExperiment()} #' function, and can be
coarsened using the \code{coarsen()} function.
}
\examples{
library(rtracklayer)
library(purrr)
library(plyranges)
TSSs_bed <- system.file("extdata", "TSSs.bed", package = "tidyCoverage")
features <- import(TSSs_bed) |> filter(strand == '+')

#############################################################################
## 1. Creating a `CoverageExperiment` object from a single BigWigFile
#############################################################################

RNA_fwd <- system.file("extdata", "RNA.fwd.bw", package = "tidyCoverage")
tracks <- BigWigFile(RNA_fwd)
CoverageExperiment(tracks, features, width = 5000)

#############################################################################
## 2. Creating a `CoverageExperiment` object from a BigWigFileList
#############################################################################

RNA_rev <- system.file("extdata", "RNA.rev.bw", package = "tidyCoverage")
tracks <- BigWigFileList(list(RNA_fwd = RNA_fwd, RNA_rev = RNA_rev))
CoverageExperiment(tracks, features, width = 5000)

#############################################################################
## 3. Creating a `CoverageExperiment` object from imported bigwig files
#############################################################################

tracks <- list(
    RNA_fwd = system.file("extdata", "RNA.fwd.bw", package = "tidyCoverage"),
    RNA_rev = system.file("extdata", "RNA.rev.bw", package = "tidyCoverage")
) |> map(import, as = 'Rle')
CoverageExperiment(tracks, features, width = 5000)

#############################################################################
## 4. Correct for strandness when recovering coverage
#############################################################################

TSSs_bed <- system.file("extdata", "TSSs.bed", package = "tidyCoverage")
features <- list(
    TSS_fwd = import(TSSs_bed) |> filter(strand == '+'), 
    TSS_rev = import(TSSs_bed) |> filter(strand == '-')
)
tracks <- list(
    RNA_fwd = system.file("extdata", "RNA.fwd.bw", package = "tidyCoverage"),
    RNA_rev = system.file("extdata", "RNA.rev.bw", package = "tidyCoverage")
) |> map(import, as = 'Rle')
CoverageExperiment(tracks, features, width = 5000, ignore.strand = FALSE)

#############################################################################
## Aggregating a `CoverageExperiment` object
#############################################################################
data(ce)
coarsen(ce, window = 10)
}
