% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spsNewtab.R
\name{spsNewTab}
\alias{spsNewTab}
\title{Create a new SPS tab}
\usage{
spsNewTab(
  tab_id = "vs_mytab",
  tab_displayname = "My custom plotting tab",
  img = "",
  app_path = getwd(),
  out_folder_path = file.path(app_path, "R"),
  author = "",
  template = c("simple", "full"),
  preview = FALSE,
  reformat = FALSE,
  open_file = TRUE,
  verbose = spsOption("verbose"),
  colorful = spsOption("use_crayon")
)
}
\arguments{
\item{tab_id}{character string, length 1, must be unique. Use
\link[=spsTabInfo]{spsTabInfo(app_path = "YOUR_APP_PATH")} to see current tab
IDs.}

\item{tab_displayname}{character string, length 1, the name to be displayed
on side navigation bar list and tab title}

\item{img}{realtive path, an image representation of the new plot. It can be
a internet link or a local link which uses the \emph{www} folder as the root.
e.g. drop your image \emph{plot.png} inside \emph{www/plot_list}, then the
link here is "plot_list/plot.png". You will see these images on "Custom Tabs"
main page. If no provided, a warning will be given on app start and an empty
image will show up on "Custom Tabs".}

\item{app_path}{string, app directory, default is current directory}

\item{out_folder_path}{string, which directory to write the new tab file,
default is the \emph{R} folder in the SPS project. If you write the file other than
\emph{R}, this file will not be automatically loaded by SPS or Shiny. You must source
it manually.}

\item{author}{character string, or a vector of strings. authors of the tab}

\item{template}{one of "simple" or "full", default "simple". "simple" gives a
tab file with minimum Shiny code, you can only focus on you R plotting code.
"full" gives the full tab code, so you can modify everything on the tab.}

\item{preview}{bool, \emph{TRUE} will print the new tab code to console and will
not write the file and will not register the tab}

\item{reformat}{bool, whether to use \link[styler:style_file]{styler::style_file} reformat the code}

\item{open_file}{bool, if Rstudio is detected, open the new tab file?}

\item{verbose}{bool, default follows the project verbosity level.
\emph{TRUE} will give you more information on progress and debugging}

\item{colorful}{bool, whether the message will be colorful or not}
}
\value{
returns a new tab file
}
\description{
create custom tabs in newer (> 1.1) version of SPS. The old
creation functions will be deprecated by next Bioconductor major release.
}
\details{
\itemize{
\item template "simple": hides the UI and server code and use \link{spsEzUI} and \link{spsEzServer} instead.
\item template "full": full tab code. You need to know some Shiny development knowledge.
}
}
\examples{
spsInit(change_wd = FALSE, overwrite = TRUE)
spsNewTab("vs_newtab_ez", app_path = glue::glue("SPS_{format(Sys.time(), '\%Y\%m\%d')}"))
spsNewTab("vs_newtab_full", template = "full",
app_path = glue::glue("SPS_{format(Sys.time(), '\%Y\%m\%d')}"))
spsNewTab("vs_newtab_pre", preview = TRUE,
app_path = glue::glue("SPS_{format(Sys.time(), '\%Y\%m\%d')}"))
}
