% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bScore.R
\name{bScore}
\alias{bScore}
\title{Calculate B-score}
\usage{
bScore(masterPlate, dta, treatment, control, outFile = FALSE)
}
\arguments{
\item{masterPlate}{a maste plate to be normalized.}

\item{dta}{synthetic lethal RNAi screen data.}

\item{treatment}{the treatment experiment condition in EXPERIMENT_MODIFICATION}

\item{control}{the control experiment condition in EXPERIMENT_MODIFICATION.}

\item{outFile}{should calculated B-score files be written to the current folder? File names is (masterPlate).bscore.csv.}
}
\value{
A list contains B-score for each master plate, treatment plates are the
  first columns, followed by control plates
}
\description{
Calculate the B-score for plates belonging to the same master plate.
Positive / negative controls are removed from the calculation.
}
\examples{
data(example_dt)
res <- sapply(unique(example_dt$MASTER_PLATE), bScore, example_dt,
              treatment = "treatment", control = "control", simplify = FALSE)
}
\references{
Brideau, C., Gunter, B., Pikounis, B. & Liaw, A. Improved statistical methods for hit selection in high-throughput screening. J. Biomol. Screen. 8, 634-647 (2003).
}
