% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_multi_drugs.R
\name{PlotMultiDrugSurface}
\alias{PlotMultiDrugSurface}
\title{3D Plot for Multi-drug Combination Dose-Response/Synergy Scores}
\usage{
PlotMultiDrugSurface(
  data,
  plot_block = 1,
  plot_value = "response",
  summary_statistic = NULL,
  plot_title = NULL,
  distance_method = "mahalanobis",
  high_value_color = "#FF0000",
  low_value_color = "#00FF00",
  show_data_points = TRUE,
  point_color = "#DDA137",
  text_size_scale = 1,
  axis_line = FALSE,
  colorbar_tick = FALSE,
  x_range = NULL,
  y_range = NULL,
  z_range = NULL,
  color_range = NULL,
  camera_width = NULL,
  camera_height = NULL,
  camera_scale = 1
)
}
\arguments{
\item{data}{A list object generated by function \code{\link{ReshapeData}}.}

\item{plot_block}{A character/integer. It indicates the block ID for the
block to visualize.}

\item{plot_value}{A vector of characters. It contains the name of one or more
metrics to be visualized. If the \code{data} is the direct output from 
\link{ReshapeData}, the values for this parameter are:
\itemize{
  \item \strong{response_origin} The original response value in input data.
  It might be \% inhibition or \% viability.
  \item \strong{response} The \% inhibition after preprocess by function 
  \link{ReshapeData}
}
If the \code{data} is the output from \link{CalculateSynergy}, following
values are also available:
\itemize{
  \item \strong{ZIP_ref, Bliss_ref, HSA_ref, Loewe_ref} The reference
  additive effects calculated by ZIP, Bliss, HSA or Loewe model,
  respectively.
  \item \strong{ZIP_synergy, Bliss_synergy, HSA_synergy, Loewe_synergy}
  The synergy score calculated by ZIP, Bliss, HSA or Loewe model,
  respectively.
  \item \strong{ZIP_fit} The response fitted by ZIP model.
}}

\item{summary_statistic}{A vector of characters or NULL. It indicates the
summary statistics for all the \code{plot_value} in whole combination
matrix. Available values are:
\itemize{
  \item \strong{mean} Median value for all the responses or synergy
  scores in the matrix and the p-value if it is valid;
  \item \strong{median} Median value for all the responses or synergy
  scores in the matrix;
  \item \strong{quantile_90} 90\% quantile. User could change the number to
  print different sample quantile. For example quantile_50 equal to median. 
}
If it is \code{NULL}, no statistics will be printed.}

\item{plot_title}{A charactor value. It specifies the plot title. If it is
\code{NULL}, the function will automatically generate a title.}

\item{distance_method}{The methods to calculate the distance between
different data points from the concentration of drugs. The distance matrix
is used for dimension reduction. This parameter is used to set the 
parameter \code{method} for \link[vegan]{vegdist}. The default values is
"mahalanobis".}

\item{high_value_color}{An R color value. It indicates the color for the
high values.}

\item{low_value_color}{An R color value. It indicates the color for low
values.}

\item{show_data_points}{A logical value. If it is \code{TRUE}, the raw data
points will be shown on the plot. If it is \code{FALSE}, no points will be
plotted.}

\item{point_color}{An R color value. It indicates the color for data points.}

\item{text_size_scale}{A numeric value. It is used to control the size
of text in the plot. All the text size will multiply by this scale factor.}

\item{axis_line}{A logical value. Whether to show the axis lines and ticks.}

\item{colorbar_tick}{A logical value. Whether to show the ticks on color bar.}

\item{x_range}{A numeric vector with two values or NULL. It is used to set
the range of x axis (coordinate 1). For example, \code{c(-5, 5)} means
coordinate 1 ranges from -5 to 5 in the plot. Default value is \code{NULL}.
The function automatically set the range.}

\item{y_range}{A numeric vector with two values or NULL. It is used to set
the range of y axis (coordinate 2). For example, \code{c(-5, 5)} means
coordinate 2 ranges from -5 to 5 in the plot. Default value is \code{NULL}.
The function automatically set the range.}

\item{z_range}{A vector of two numeric values. They specify the range of
z-axis plotted.Default value is \code{NULL}. The function
automatically set the range.}

\item{color_range}{A vector of two numeric values. They specify the range
of the color bars. The first item (lower bounder) must be less than the
second one (upper bounder). The plotted values larger than defined upper
bounder will be filled in color \code{high_value_color}. The plotted values
less than defined lower bounder will be filled in color
\code{low_value_color}. If the defined range includes 0, value 0 will be
filled in color "white". By default, it is set as \code{NULL} which
means the function will automatically set the color range according to
the plotted values.}

\item{camera_width}{A numeric value or NULL. It indicates the output figure's
width on pixel.}

\item{camera_height}{A numeric value or NULL. It indicates the output
figure's height on pixel.}

\item{camera_scale}{A numeric value. The output plot while clicking the
camera button.will multiply title/legend/axis/canvas sizes by this factor.}
}
\value{
A plotly plot object.
}
\description{
This function will generate a dynamic 3D plot response values or synergy
scores for all the observed data points in a multi-drug combination block.
The concentrations of drugs will be projected to 2 dimensions and plot along 
x an y axis. A surface for the selected \code{plot_value} and points for
all the concentration combinations will be plotted.
}
\examples{
data("NCATS_screening_data")
data <- ReshapeData(NCATS_screening_data)
p <- PlotMultiDrugSurface(
  data,
  plot_block = 1,
  plot_value = "response",
  show_data_points = TRUE,
  distance_method = "mahalanobis",
  summary_statistic = "mean"
)
p
}
\author{
\itemize{
  \item Shuyu Zheng \email{shuyu.zheng@helsinki.fi}
  \item Jing Tang \email{jing.tang@helsinki.fi}
}
}
