% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_synergy_score.R
\name{Loewe}
\alias{Loewe}
\title{Calculate Loewe Synergy Score}
\usage{
Loewe(response, Emin = NA, Emax = NA, quiet = TRUE)
}
\arguments{
\item{response}{A data frame. It must contain the columns: "conc1", "conc2",
..., for the concentration of the combined drugs and "response" for the
observed \%inhibition at certain combination.}

\item{Emin}{The expected minimum response value in the 4 parameter 
log-logistic model.}

\item{Emax}{The expected maximum response value in the 4 parameter 
log-logistic model.}

\item{quiet}{A logical value. If it is \code{TRUE} then the warning message
will not show during calculation.}
}
\value{
A data frame containing the concentrations for drugs, reference
  effect and synergy score estimated by Loewe model.
}
\description{
\code{Loewe} calculates the synergy score matrix from a dose-response matrix
by using a druginteraction reference model introduced by Loewe in 1953.
}
\details{
Loewe model is a reference model for evaluating the combination
effect of two drugs. The basic assumption of this model is "The referece
effect of drug combination is the expected effect of a drug combined with
itself". \cr
\cr
The optional arguments \code{drug.col.model}, \code{drug.row.model} are
designed for reuse the single drug dose response model fitting results,
if it has been down before. Functions \code{\link{FitDoseResponse}} and
\code{\link{ExtractSingleDrug}} could be used to calculate these arguments.
}
\examples{
data("mathews_screening_data")
data <- ReshapeData(mathews_screening_data)
response <- data$response[data$response$block_id == 1, 
                          c("conc1", "conc2", "response")]
Loewe.score <- Loewe(response)

}
\references{
\itemize{
   \item{Yadav B, Wennerberg K, Aittokallio T, Tang J.(2015).
   \href{https://doi.org/10.1016/j.csbj.2015.09.001}{Searching for Drug
   Synergy in Complex Dose-Response Landscape Using an Interaction Potency
   Model.}Comput Struct Biotechnol J, 13:504– 513.}
   \item{[Loewe, 1953] Loewe, S. (1953).
   \href{https://www.ncbi.nlm.nih.gov/pubmed/13081480}{The problem of
   synergism and antagonism of combined drugs.} Arzneimittelforschung,
   3(6):285–290.
   }
}
}
\author{
\itemize{
    \item Shuyu Zheng \email{shuyu.zheng@helsinki.fi}
    \item Jing Tang \email{jing.tang@helsinki.fi}
 }
}
