% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/count_foci.R
\name{count_foci}
\alias{count_foci}
\title{count_foci}
\usage{
count_foci(
  img_path,
  stage = "none",
  offset_px = 0.2,
  offset_factor = 2,
  brush_size = 3,
  brush_sigma = 3,
  foci_norm = 0.01,
  annotation = "off",
  channel2_string = "SYCP3",
  channel1_string = "MLH3",
  file_ext = "jpeg",
  KO_str = "--",
  WT_str = "++",
  KO_out = "-/-",
  WT_out = "+/+",
  watershed_stop = "off",
  watershed_radius = 1,
  watershed_tol = 0.05,
  crowded_foci = TRUE,
  artificial_amp_factor = 1,
  strand_amp = 2,
  min_foci = -1,
  disc_size = 51,
  modify_problematic = "off",
  disc_size_foci = 5,
  C1 = 0.02,
  C2 = 0.46,
  C_weigh_foci_number = TRUE
)
}
\arguments{
\item{img_path, }{path containing crops to analyse}

\item{stage, }{meiosis stage of interest. Currently count_foci determines
this with thresholding/ object properties in the synaptonemal complex channel
by previosly calling the get_pachytene function.
Note that if using this option, the count_foci function requires that the
input directory contains a folder called “pachytene” with the crops in it.}

\item{offset_px, }{Pixel value offset used in thresholding of synaptonemal complex channel}

\item{offset_factor, }{Pixel value offset used in thresholding of foci channel}

\item{brush_size, }{size of brush to smooth the foci channel. Should be small
to avoid erasing foci.}

\item{brush_sigma, }{sigma for Gaussian smooth of foci channel. Should be
small to avoid erasing foci.}

\item{foci_norm, }{Mean intensity to normalise all foci channels to.}

\item{annotation, }{Choice to output pipeline choices (recommended to knit)}

\item{channel2_string}{String appended to the files showing the channel
illuminating synaptonemal complexes. Defaults to SYCP3}

\item{channel1_string}{String appended to the files showing the channel
illuminating foci. Defaults to MLH3}

\item{file_ext}{file extension of your images e.g. tiff jpeg or png.}

\item{KO_str}{string in filename corresponding to knockout genotype.
Defaults to --.}

\item{WT_str}{string in filename corresponding to wildtype genotype.
Defaults to ++.}

\item{KO_out}{string in output csv in genotype column, for knockout.
Defaults to -/-.}

\item{WT_out}{string in output csv in genotype column, for knockout.
Defaults to +/+.}

\item{watershed_stop}{Stop default watershed method with "on"}

\item{watershed_radius}{Radius (ext variable) in watershed method used
in foci channel. Defaults to 1 (small)}

\item{watershed_tol}{Intensity tolerance for watershed method. Defaults to 0.05.}

\item{crowded_foci}{TRUE or FALSE, defaults to FALSE. Set to TRUE if you
have foci > 100 or so.}

\item{artificial_amp_factor}{Amplification of foci channel, for annotation only.}

\item{strand_amp}{multiplication of strand channel to make masks}

\item{min_foci}{minimum pixel area for a foci. Depends on your dpi etc. Defaults to 4}

\item{disc_size}{size of disc for local background calculation in synaptonemal complex channel}

\item{modify_problematic}{option for synapsis to try and "save" images which
have likely been counted incorrectly due to a number of reasons. Default
settings are optimized for mouse pachytene. Defaults to "off"}

\item{disc_size_foci}{size of disc for local background calculation in foci channel}

\item{C1}{Default crispness criteria = sd(foci_area)/(mean(foci_area)+1)}

\item{C2}{Alternative crisp criteria.}

\item{C_weigh_foci_number}{choose crispness criteria- defaults to TRUE to use
C1 (weighing with number). Otherwise set to FALSE to use C2}
}
\value{
data frame with foci count per cell
}
\description{
Calculates coincident foci in synaptonemal complex and foci channel, per cell
}
\details{
In this function, masks for the synaptonemal complex (SC) and foci channel
are created from the saved crops of single/individual cells.
These masks are computed using (optional) input parameters related
to meiosis stage/ how well spread chromosomes are (for the former)
and related to smoothing, thresholding and how "crowded" foci are for the
latter. Finally, these two masks are multiplied, and the number of
objects found with EBImage's computeFeatures are the colocalizing foci.

The file, cell number, foci count etc. are output as a data frame.
}
\examples{
demo_path = paste0(system.file("extdata",package = "synapsis"))
foci_counts <- count_foci(demo_path,offset_factor = 3, brush_size = 3,
brush_sigma = 3, annotation = "on",stage = "pachytene")
}
\author{
Lucy McNeill
}
