% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lm_pi0.R
\name{lm_pi0}
\alias{lm_pi0}
\title{Estimation of pi0, proportion of p-values consistent with a null hypothesis}
\usage{
lm_pi0(
  p,
  lambda = seq(0.05, 0.95, 0.05),
  X,
  type = c("logistic", "linear"),
  smooth.df = 3,
  threshold = TRUE,
  smoothing = c("unit.spline", "smooth.spline")
)
}
\arguments{
\item{p}{numeric vector, p-values}

\item{lambda}{numeric vector, thresholds used to bin pvalues,
must be in [0,1).}

\item{X}{numeric matrix, covariates that might be related to p values
(one test per row, one variable per column).}

\item{type}{character, type of regression used to fit features to pvalues}

\item{smooth.df}{integer, degrees of freedom when estimating pi0(x) with
a smoother.}

\item{threshold}{logical, if TRUE, all estimates are thresholded into unit
interval; if FALSE, all estimates are left as they are computed}

\item{smoothing}{character, type of smoothing used to fit pi0}
}
\value{
object of class `lm_pi0', which is a list with several components
\item{call}{matched function call}
\item{lambda}{numeric vector of thresholds used in calculating pi0.lambda}
\item{X.names}{character vector of covariates used in modeling}
\item{pi0.lambda}{numeric matrix of estimated pi0(x) for each value of
lambda. The number of columns is the number of tests, the number of rows is
the length of lambda.}
\item{pi0}{numerical vector of smoothed estimate of pi0(x).
The length is the number of rows in X.}
\item{pi0.smooth}{(only output with smoothing="smooth.spline") Matrix of
fitted values from the smoother fit to the pi0(x) estimates at each value
of lambda (same number of rows and columns as pi0.lambda)}
}
\description{
Estimation of pi0, proportion of p-values consistent with a null hypothesis
}
\examples{
# define a covariate
X <- seq(-1,2,length=1000)
# set probability of being null
pi0 <- 1/4*X + 1/2
# generate null/alternative p-values
nullI <- rbinom(1000,prob=pi0,size=1)> 0
# vector of p-values
pValues <- rep(NA,1000) 
pValues[nullI] <- runif(sum(nullI)) # from U(0,1)
pValues[!nullI] <- rbeta(sum(!nullI),1,2) # from Beta
pi0x <- lm_pi0(pValues, X=X)

}
