% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cv_voting.R
\name{cv_voting}
\alias{cv_voting}
\title{For a \code{survClust} fit, return consolidated labels across rounds of cross validation for a specific \code{k}.
Note that cv.fit already has consolidated class labels across folds}
\usage{
cv_voting(
  cv.fit,
  dat.dist,
  pick_k,
  cmd.k = NULL,
  pick_k.test = TRUE,
  minlabel.test = TRUE
)
}
\arguments{
\item{cv.fit}{fit objects as returned from \code{cv_survclust}}

\item{dat.dist}{weighted distance matrices from \code{getDist}}

\item{pick_k}{choice of k cluster to summarize over rounds of cross validation}

\item{cmd.k}{number of dimensions used by \code{cmdscale} to perform clustering on. Defaults is \code{n-1}}

\item{pick_k.test}{logical, only selects cv.fit solutions where the resulting solution after consolidation contains \code{pick_k} classes. Default TRUE. Avoids edge cases, but in some cases FALSE might be desirable}

\item{minlabel.test}{logical, only selects cv.fit solutions where classes have a minimum of 5 samples. Default TRUE. Avoids edge cases, but in some cases FALSE might be desirable}
}
\value{
final.labels consolidated class labels over rounds of cross-validation
}
\description{
For a \code{survClust} fit, return consolidated labels across rounds of cross validation for a specific \code{k}.
Note that cv.fit already has consolidated class labels across folds
}
\examples{
library(survClust)
k4 <- cv_voting(uvm_survClust_cv.fit, getDist(uvm_dat, uvm_survdat), pick_k = 4)
table(k4)

}
\author{
Arshi Arora
}
