% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/struct_class.R
\docType{class}
\name{struct_class-class}
\alias{struct_class-class}
\alias{.struct_class}
\title{\code{struct_class} object definition}
\value{
Returns a \pkg{struct} object
}
\description{
Defines the struct class base template. This class is inherited by other objects
and not intended for direct use. It defines slots and methods common to all
\pkg{struct} objects.
}
\section{Public slots}{

Public slots can be accessed using shorthand $ notation and are intended for
users building workflows.

\describe{
  \item{\code{name}}{\code{character()} A short descriptive name of the struct object}
  \item{\code{description}}{\code{character()} A longer description of the struct object and what it does}
  \item{\code{type}}{\code{character()} A keyword that describes the type of struct object}
  \item{\code{libraries}}{\code{character()} A (read only) list of R packages used by this struct object}
  \item{\code{citations}}{\code{list of bibentry} A (read only) list of citations relevant to this struct object,
  in Bibtex format.}
}
}

\section{Private slots}{

Private slots are not readily accessible to users and are intended for developers
creating their own struct objects. Any slot not listed within `.params` or
`.outputs` is considered a private slot.

\describe{
  \item{\code{.params}}{\code{character()} A list of additional slot names that can be get/set by the user
  for a specific struct object. These are used as input parameters for different methods.}
  \item{\code{.outputs}}{\code{character()} a list of additional slot names that can be get by the user. These are
  used to store the results of a method.}
}
}

\examples{
S = struct_class(name = 'Example',description = 'An example object')
}
