% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/struct_class.R
\name{set_obj_method}
\alias{set_obj_method}
\title{update method for a struct object}
\usage{
set_obj_method(
  class_name,
  method_name,
  definition,
  where = topenv(parent.frame()),
  signature = c(class_name, "DatasetExperiment")
)
}
\arguments{
\item{class_name}{the name of the to update the method for}

\item{method_name}{the name of the method to update. Must be an existing method for the object.}

\item{definition}{the function to replace the method with. This function will be used when the method is called on the object.}

\item{where}{the environment to create the object in. default where = topenv(parent.frame())}

\item{signature}{a list of classes that this object requires as inputs. Default is c(class_name,'DatasetExperiment')}
}
\value{
a method is created in the specified environment
}
\description{
a helper function to update methods for a struct object
}
\examples{
set_struct_obj(
class_name = 'add_two_inputs',
struct_obj = 'model',
params = c(input_1 = 'numeric', input_2 = 'numeric'),
outputs = c(result = 'numeric'),
prototype = list(
   input_1 = 0,
   input_2 = 0,
   name = 'Add two inputs',
   description = 'example class that adds two values together')
)
}
