% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/parameter_class.R
\name{param_obj}
\alias{param_obj}
\alias{param_obj<-}
\alias{param_obj<-,struct_class,character-method}
\alias{param_obj,struct_class,character-method}
\title{Parameter objects}
\usage{
param_obj(obj, name)

param_obj(obj, name) <- value

\S4method{param_obj}{struct_class,character}(obj, name) <- value

\S4method{param_obj}{struct_class,character}(obj, name)
}
\arguments{
\item{obj}{An object derived from struct_class}

\item{name}{Name of parameter}

\item{value}{A valid value for the parameter being set}
}
\value{
\describe{
\item{\code{param_obj(M,name)}}{Returns the named parameter as an object}
\item{\code{param_obj(M,name)<-}}{Sets the named parameter of an object}
}
}
\description{
Gets or sets the object of a parameter e.g. to an entity() object.
}
\examples{
# get the parameter as an object
M = example_model()
obj = param_obj(M, 'value_0')

# set a parameter as an object
param_obj(M, 'value_0') = entity(value = 15,type = 'numeric',name='value_0')
}
