% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/split_data_class.R
\name{split_data}
\alias{split_data}
\title{Split data}
\usage{
split_data(p_train, ...)
}
\arguments{
\item{p_train}{(numeric) The proportion of samples selected for the training set.}

\item{...}{Additional slots and values passed to \code{struct_class}.}
}
\value{
A  \code{split_data} object with the following \code{output} slots:
\tabular{ll}{
\code{training} \tab          (DatasetExperiment) A DatasetExperiment object containing samples selected for the training set. \cr
\code{testing} \tab          (DatasetExperiment) A DatasetExperiment object containing samples selected for the testing set. \cr
}
}
\description{
The data matrix is divided into two subsets.A predefined proportion of the samples are randomly selected for a training set, and the remaining samples are used for the test set.
}
\section{Inheritance}{

A \code{split_data} object inherits the following \code{struct} classes: \cr\cr
\verb{[split_data]} >> \verb{[model]} >> \verb{[struct_class]}
}

\examples{
M = split_data(
      p_train = 0.75)

M = split_data(p_train=0.75)

}
