% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootstrap_class.R,
%   R/forward_selection_by_rank_class.R, R/grid_search_1d_class.R,
%   R/kfold_xval_class.R, R/permutation_test_class.R,
%   R/permute_sample_order_class.R, R/resample_class.R, R/run_doc.R
\name{run,bootstrap,DatasetExperiment,metric-method}
\alias{run,bootstrap,DatasetExperiment,metric-method}
\alias{run,forward_selection_by_rank,DatasetExperiment,metric-method}
\alias{run,grid_search_1d,DatasetExperiment,metric-method}
\alias{run,kfold_xval,DatasetExperiment,metric-method}
\alias{run,permutation_test,DatasetExperiment,metric-method}
\alias{run,permute_sample_order,DatasetExperiment,metric-method}
\alias{run,resample,DatasetExperiment,metric-method}
\alias{run}
\title{Runs an iterator, applying the chosen model multiple times.}
\usage{
\S4method{run}{bootstrap,DatasetExperiment,metric}(I, D, MET = NULL)

\S4method{run}{forward_selection_by_rank,DatasetExperiment,metric}(I, D, MET)

\S4method{run}{grid_search_1d,DatasetExperiment,metric}(I, D, MET)

\S4method{run}{kfold_xval,DatasetExperiment,metric}(I, D, MET = NULL)

\S4method{run}{permutation_test,DatasetExperiment,metric}(I, D, MET = NULL)

\S4method{run}{permute_sample_order,DatasetExperiment,metric}(I, D, MET)

\S4method{run}{resample,DatasetExperiment,metric}(I, D, MET)
}
\arguments{
\item{I}{an iterator object}

\item{D}{a DatasetExperiment object}

\item{MET}{a metric object}
}
\value{
Modified iterator object
}
\description{
Running an iterator will apply the iterator a number of times to a DatasetExperiment.
For example, in cross-validation the same model is applied multiple times to
the same data, splitting it into training and test sets. The input metric
object can be calculated and collected for each iteration as an output.
}
\examples{
D = iris_DatasetExperiment() # get some data
MET = metric()  # use a metric
I = example_iterator() # initialise iterator
models(I) = example_model() # set the model
I = run(I,D,MET) # run
}
