% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PLSDA_charts.R
\name{plsda_predicted_plot}
\alias{plsda_predicted_plot}
\title{PLSDA predicted plot}
\usage{
plsda_predicted_plot(factor_name, style = "boxplot", ycol = 1, ...)
}
\arguments{
\item{factor_name}{(character) The name of a sample-meta column to use.}

\item{style}{(character) Plot style. Allowed values are limited to the following: \itemize{ \item{\code{"boxplot"}: A boxplot.}\item{\code{"violin"}: A violin plot.}\item{\code{"density"}: A density plot.}} The default is \code{"boxplot"}.}

\item{ycol}{(character, numeric, integer) The column of the Y block to be plotted. The default is \code{1}.\cr}

\item{...}{Additional slots and values passed to \code{struct_class}.}
}
\value{
A  \code{
plsda_predicted_plot
} object. This object has no \code{output} slots.
See \code{\link[struct]{chart_plot}} in the \code{struct} package to plot this chart object.
}
\description{
A plot of the regression coefficients from a PLSDA model.
}
\details{
This object makes use of functionality from the following packages:\itemize{  \item{\code{pls}} \item{\code{ggplot2}}}
}
\section{Inheritance}{

A \code{plsda_predicted_plot} object inherits the following \code{struct} classes: \cr\cr
\verb{[plsda_predicted_plot]} >> \verb{[chart]} >> \verb{[struct_class]}
}

\examples{
M = plsda_predicted_plot(
      factor_name = "V1",
      style = "boxplot",
      ycol = 1)

D = iris_DatasetExperiment()
M = mean_centre()+PLSDA(factor_name='Species')
M = model_apply(M,D)

C = plsda_predicted_plot(factor_name='Species')
chart_plot(C,M[2])
}
\references{
Liland K, Mevik B, Wehrens R (2023). \emph{pls: Partial Least Squares and
Principal Component Regression}. R package version 2.8-3,
\url{https://CRAN.R-project.org/package=pls}.

Wickham H (2016). \emph{ggplot2: Elegant Graphics for Data Analysis}.
Springer-Verlag New York. ISBN 978-3-319-24277-4,
\url{https://ggplot2.tidyverse.org}.
}
