% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarizeHist.R
\name{.summarizeHist}
\alias{.summarizeHist}
\title{Summarize the histogram of strand proportions from the input windows
data frame}
\usage{
.summarizeHist(
  windows,
  split = c(10L, 100L, 1000L),
  breaks = 100L,
  useCoverage = FALSE,
  groupBy = NULL,
  normalizeBy = NULL
)
}
\arguments{
\item{windows}{data frame containing the strand information of the sliding
windows. Windows can be obtained using the function \code{getStrandFromBamFile}.}

\item{split}{an integer vector that specifies how you want to partition the
windows based on the coverage. By default \code{split} = c(10,100,1000),
which means that your windows will be partitionned into 4 groups, those have
coverage < 10, from 10 to 100, from 100 to 1000, and > 1000}

\item{breaks}{an integer giving the number of bins for the histogram}

\item{useCoverage}{if TRUE then plot the coverage strand information,
otherwise plot the number of reads strand information. FALSE by default}

\item{groupBy}{the column names of windows that will be used to group
the data}

\item{normalizeBy}{instead of using the raw read count/coverage, we will
normalize it to a proportion by dividing it to the total number of read
count/coverage of windows that have the same value in the \code{normalizeBy}
columns.}
}
\value{
a dataframe object
}
\description{
Summarize the histogram of positive proportions from the input
windows obtained from the function \code{getStrandFromBamFile}
}
\seealso{
getStrandFromBamFile, plotHist, plotWin
}
\keyword{internal}
