% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/batchCorrection.R
\name{geomxBatchCorrection}
\alias{geomxBatchCorrection}
\title{Batch correction for GeoMX data}
\usage{
geomxBatchCorrection(
  spe,
  k,
  factors,
  NCGs,
  n_assay = 2,
  batch = NULL,
  batch2 = NULL,
  covariates = NULL,
  design = matrix(1, ncol(spe), 1),
  method = c("RUV4", "Limma", "RUVg"),
  isLog = TRUE,
  outAssay = "logcounts"
)
}
\arguments{
\item{spe}{A Spatial Experiment object.}

\item{k}{The number of unwanted factors to use. Can be 0. This is required for the RUV4 method.}

\item{factors}{Column name(s) to indicate the factors of interest. This is required for the RUV4 method.}

\item{NCGs}{Negative control genes. This is required for the RUV4 method.}

\item{n_assay}{Integer to indicate the nth count table in the assay(spe) to be used.}

\item{batch}{A vector indicating batches. This is required for the Limma method.}

\item{batch2}{A vector indicating the second series of batches. This is specific for the Limma method.}

\item{covariates}{A matrix or vector of numeric covariates to be adjusted for.}

\item{design}{A design matrix relating to treatment conditions to be preserved, can be generated using \code{stats::model.matrix} function with all biological factors included.}

\item{method}{Can be either RUV4 or Limma or RUVg, by default is RUV4.}

\item{isLog}{Logical vector, indicating if the count table is log or not.}

\item{outAssay}{Output assay name, logcounts by default.}
}
\value{
A Spatial Experiment object, containing the normalized count and normalization factor. For method RUV4 and RUVg, the W matrices will be saved in the colData of the object.
}
\description{
Batch correction for GeoMX data
}
\note{
The normalised count is not intended to be used directly for linear modelling. For linear modelling, it is better to include the batch factors/W matrices in the linear model.
}
\examples{
data("dkd_spe_subset")
spe <- findNCGs(dkd_spe_subset, top_n = 100)
spe_ruv <- geomxBatchCorrection(spe,
  k = 3,
  factors = c("disease_status", "region"),
  NCGs = S4Vectors::metadata(spe)$NCGs
)

}
\references{
Gagnon-Bartsch, J. A., Jacob, L., & Speed, T. P. (2013). Removing unwanted variation from high dimensional data with negative controls. Berkeley: Tech Reports from Dep Stat Univ California, 1-112.

Ritchie, M. E., Phipson, B., Wu, D. I., Hu, Y., Law, C. W., Shi, W., & Smyth, G. K. (2015). limma powers differential expression analyses for RNA-sequencing and microarray studies. Nucleic acids research, 43(7), e47-e47.
}
