% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/batchCorrection.R
\name{findNCGs}
\alias{findNCGs}
\title{Get negative control genes from each batch of the data}
\usage{
findNCGs(spe, n_assay = 2, batch_name = "SlideName", top_n = 200)
}
\arguments{
\item{spe}{A Spatial Experiment object.}

\item{n_assay}{Integer to indicate the nth count table in the assay(spe) to be used.}

\item{batch_name}{Column name indicating batches.}

\item{top_n}{Integer indicate how many genes to be included as negative control genes.}
}
\value{
A Spatial Experiment object, conatining negative control genes in the metadata.
}
\description{
Get negative control genes from each batch of the data
}
\examples{
data("dkd_spe_subset")

spe <- findNCGs(dkd_spe_subset, top_n = 100)
S4Vectors::metadata(spe)$NCGs

}
