% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rasterization.R
\name{mosaicIntPlot}
\alias{mosaicIntPlot}
\title{Mosaic plot}
\usage{
mosaicIntPlot(sampleInfo, mosaicIntegration)
}
\arguments{
\item{sampleInfo}{A dataset of a human breast cancer sample containing the
pixel information and cluster labels for each barcode.}

\item{mosaicIntegration}{A raster object converted from a labeled spatial tissue map.}
}
\value{
A mosaic plot with labeled pixels.
}
\description{
Visualization of the rasterization results and label coding of the sample.
}
\examples{
fpath <- system.file("extdata", "dataframe.rda", package="stJoincount")
load(fpath)
mosaicIntegration <- rasterizeEachCluster(humanBC)
mosaicIntPlot(humanBC, mosaicIntegration)

}
