\name{plot_signal_condition_exp}
\alias{plot_signal_condition_exp}
\title{
  Plot the signal and background distribution of a correlation matrix.
}
\description{
  This function allows users to visualize the distributions of (assumed)
  signal and background, conditional on expression levels.  The
  predicted signals are defined by the 0.1\% highest correlations in
  each bin.
}
\usage{
plot_signal_condition_exp(cor_mat, ave_exp, signal)
}
\arguments{
  \item{cor_mat}{Matrix, correlation matrix, generated by gene
    expression matrix}
  \item{ave_exp}{Vector, average expression level of each gene for the
    normalized expression matrix}
  \item{signal}{a value between 0 and 1 giving the fraction of
    correlations which should be considered signal. We often use a value
    of \code{0.001}.}
}
\note{
  The mnemonic for \code{condition_exp} is \sQuote{conditional on
    expression}.
}
\value{
  Invoked for the side effect of producing a plot.
}
\examples{
if(require(spqnData)) {
  data(gtex.4k)
  cor_mat <- cor(t(assay(gtex.4k)))
  ave_logrpkm <- rowData(gtex.4k)$ave_logrpkm
  plot_signal_condition_exp(cor_mat, ave_exp=ave_logrpkm, signal=0.05)}
}
