% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/splat-estimate.R
\name{splatEstMean}
\alias{splatEstMean}
\title{Estimate Splat mean parameters}
\usage{
splatEstMean(norm.counts, params)
}
\arguments{
\item{norm.counts}{library size normalised counts matrix.}

\item{params}{SplatParams object to store estimated values in.}
}
\value{
SplatParams object containing the estimated parameters.
}
\description{
Estimate rate and shape parameters for the gamma distribution used to
simulate gene expression means.
}
\details{
Parameters for the gamma distribution are estimated by fitting the mean
normalised counts using \code{\link[fitdistrplus]{fitdist}}. The 'maximum
goodness-of-fit estimation' method is used to minimise the Cramer-von Mises
distance. This can fail in some situations, in which case the 'method of
moments estimation' method is used instead. Prior to fitting the means are
winsorized by setting the top and bottom 10 percent of values to the 10th
and 90th percentiles.
}
\keyword{internal}
