% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/KersplatParams-methods.R,
%   R/Params-methods.R, R/SplatParams-methods.R
\name{setParams}
\alias{setParams}
\alias{setParams,KersplatParams-method}
\alias{setParams,Params-method}
\alias{setParams,SplatParams-method}
\title{Set parameters}
\usage{
setParams(object, update = NULL, ...)

\S4method{setParams}{KersplatParams}(object, update = NULL, ...)

\S4method{setParams}{Params}(object, update = NULL, ...)

\S4method{setParams}{SplatParams}(object, update = NULL, ...)
}
\arguments{
\item{object}{Params object to set parameters in.}

\item{update}{list of parameters to set where \code{names(update)} are the
names of the parameters to set and the items in the list are values.}

\item{...}{additional parameters to set. These are combined with any
parameters specified in \code{update}.}
}
\value{
Params object with updated values.
}
\description{
Set multiple parameters in a Params object.
}
\details{
Each parameter is set by a call to \code{\link{setParam}}. If the same
parameter is specified multiple times it will be set multiple times.
Parameters can be specified using a list via \code{update} (useful when
collecting parameter values in some way) or individually (useful when setting
them manually), see examples.
}
\examples{
params <- newSimpleParams()
params
# Set individually
params <- setParams(params, nGenes = 1000, nCells = 50)
params
# Set via update list
params <- setParams(params, list(mean.rate = 0.2, mean.shape = 0.8))
params

}
