% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kersplat-simulate.R
\name{kersplatSimCellMeans}
\alias{kersplatSimCellMeans}
\title{Simulate Kersplat cell means}
\usage{
kersplatSimCellMeans(sim, params, verbose)
}
\arguments{
\item{sim}{SingleCellExperiment containing simulation.}

\item{params}{KersplatParams object with simulation parameters.}

\item{verbose}{logical. Whether to print progress messages}
}
\value{
SingleCellExperiment with cell means
}
\description{
Simulate endogenous counts for each cell in a Kersplat simulation
}
\details{
Cells are first assigned to a path and a step along that path. This is
controlled by the \code{cells.design} parameter which is a \code{data.frame}
with the columns "Path", "Probability", "Alpha" and "Beta". The Path field
is an ID for each path and the Probability field is the probability that a
cell will come from that path (must sum to 1). The Alpha and Beta parameters
control the density of cells along the path. After they are assigned to paths
the step for each cell is sampled from a Beta distribution with parameters
shape1 equals Alpha and shape2 equals beta. This approach is very flexible
and allows almost any distribution of cells along a path. The distribution
can be viewed using \code{hist(rbeta(10000, Alpha, Beta), breaks = 100)}.
Some useful combinations of parameters are:

\describe{
    \item{\code{Alpha = 1}, \code{Beta = 1}}{Uniform distribution along the
    path}
    \item{\code{Alpha = 0}, \code{Beta = 1}}{All cells at the start of the
    path.}
    \item{\code{Alpha = 1}, \code{Beta = 0}}{All cells at the end of the
    path.}
    \item{\code{Alpha = 0}, \code{Beta = 0}}{Cells only at each end of the
    path.}
    \item{\code{Alpha = 1}, \code{Beta = 2}}{Linear skew towards the start
    of the path}
    \item{\code{Alpha = 0.5}, \code{Beta = 1}}{Curved skew towards the start
    of the path}
    \item{\code{Alpha = 2}, \code{Beta = 1}}{Linear skew towards the end
    of the path}
    \item{\code{Alpha = 1}, \code{Beta = 0.5}}{Curved skew towards the end
    of the path}
    \item{\code{Alpha = 0.5}, \code{Beta = 0.5}}{Curved skew towards both
    ends of the path}
    \item{\code{Alpha = 0.5}, \code{Beta = 0.5}}{Curved skew away from both
    ends of the path}
}

Once cells are assigned to paths and steps the correct means are extracted
from the \code{paths.means} parameter and adjusted based on each cell's
library size. An adjustment for BCV is then applied. Doublets are also
simulated at this stage by selecting two path/step combinations and averaging
the means.
}
\keyword{internal}
