% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kersplat-estimate.R
\name{kersplatEstimate}
\alias{kersplatEstimate}
\alias{kersplatEstimate.SingleCellExperiment}
\alias{kersplatEstimate.matrix}
\title{Estimate Kersplat simulation parameters}
\usage{
kersplatEstimate(counts, params = newKersplatParams(), verbose = TRUE)

\method{kersplatEstimate}{SingleCellExperiment}(counts, params = newKersplatParams(), verbose = TRUE)

\method{kersplatEstimate}{matrix}(counts, params = newKersplatParams(), verbose = TRUE)
}
\arguments{
\item{counts}{either a counts matrix or a SingleCellExperiment object
containing count data to estimate parameters from.}

\item{params}{KersplatParams object to store estimated values in.}

\item{verbose}{logical. Whether to print progress messages.}
}
\value{
KersplatParams object containing the estimated parameters.
}
\description{
Estimate simulation parameters for the Kersplat simulation from a real
dataset. See the individual estimation functions for more details on how this
is done.
}
\examples{

if (requireNamespace("igraph", quietly = TRUE)) {
    # Load example data
    library(scuttle)
    set.seed(1)
    sce <- mockSCE()

    params <- kersplatEstimate(sce)
    params
}
}
\seealso{
\code{\link{kersplatEstMean}},  \code{\link{kersplatEstBCV}},
\code{\link{kersplatEstLib}}
}
