% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare.R
\name{compareSCEs}
\alias{compareSCEs}
\title{Compare SingleCellExperiment objects}
\usage{
compareSCEs(
  sces,
  point.size = 0.1,
  point.alpha = 0.1,
  fits = TRUE,
  colours = NULL
)
}
\arguments{
\item{sces}{named list of SingleCellExperiment objects to combine and
compare.}

\item{point.size}{size of points in scatter plots.}

\item{point.alpha}{opacity of points in scatter plots.}

\item{fits}{whether to include fits in scatter plots.}

\item{colours}{vector of colours to use for each dataset.}
}
\value{
List containing the combined datasets and plots.
}
\description{
Combine the data from several SingleCellExperiment objects and produce some
basic plots comparing them.
}
\details{
The returned list has three items:

\describe{
    \item{\code{RowData}}{Combined row data from the provided
    SingleCellExperiments.}
    \item{\code{ColData}}{Combined column data from the provided
    SingleCellExperiments.}
    \item{\code{Plots}}{Comparison plots
        \describe{
            \item{\code{Means}}{Boxplot of mean distribution.}
            \item{\code{Variances}}{Boxplot of variance distribution.}
            \item{\code{MeanVar}}{Scatter plot with fitted lines showing the
            mean-variance relationship.}
            \item{\code{LibrarySizes}}{Boxplot of the library size
            distribution.}
            \item{\code{ZerosGene}}{Boxplot of the percentage of each gene
            that is zero.}
            \item{\code{ZerosCell}}{Boxplot of the percentage of each cell
            that is zero.}
            \item{\code{MeanZeros}}{Scatter plot with fitted lines showing
            the mean-zeros relationship.}
            \item{\code{VarGeneCor}}{Heatmap of correlation of the 100 most
            variable genes.}
    }
  }
}

The plots returned by this function are created using
\code{\link[ggplot2]{ggplot}} and are only a sample of the kind of plots you
might like to consider. The data used to create these plots is also returned
and should be in the correct format to allow you to create further plots
using \code{\link[ggplot2]{ggplot}}.
}
\examples{
sim1 <- splatSimulate(nGenes = 1000, batchCells = 20)
sim2 <- simpleSimulate(nGenes = 1000, nCells = 20)
comparison <- compareSCEs(list(Splat = sim1, Simple = sim2))
names(comparison)
names(comparison$Plots)
}
