% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spicy.R
\name{getPairwise}
\alias{getPairwise}
\title{Get statistic from pairwise L curve of a single image.}
\usage{
getPairwise(
  cells,
  imageID = "imageID",
  cellType = "cellType",
  spatialCoords = c("x", "y"),
  r = NULL,
  sigma = NULL,
  from = NULL,
  to = NULL,
  cores = 1,
  minLambda = 0.05,
  window = "convex",
  window.length = NULL,
  edgeCorrect = TRUE,
  includeZeroCells = FALSE,
  BPPARAM = NULL,
  imageIDCol = imageID,
  cellTypeCol = cellType,
  spatialCoordCols = spatialCoords,
  nCores = cores,
  Rs = r
)
}
\arguments{
\item{cells}{A SummarizedExperiment that contains at least the
variables x and y, giving the location coordinates of each cell, and
cellType.}

\item{imageID}{The name of the imageID column if using a SingleCellExperiment or SpatialExperiment.}

\item{cellType}{The name of the cellType column if using a SingleCellExperiment or SpatialExperiment.}

\item{spatialCoords}{The names of the spatialCoords column if using a SingleCellExperiment.}

\item{r}{A vector of the radii that the measures of association should be calculated over.}

\item{sigma}{A numeric variable used for scaling when fitting inhomogenous L-curves.}

\item{from}{The 'from' cellType for generating the L curve.}

\item{to}{The 'to' cellType for generating the L curve.}

\item{cores}{Number of cores to use for parallel processing or a BiocParallel MulticoreParam or SerialParam object.}

\item{minLambda}{Minimum value density for scaling when fitting inhomogeneous L-curves.}

\item{window}{Should the window around the regions be 'square', 'convex' or 'concave'.}

\item{window.length}{A tuning parameter for controlling the level of concavity when estimating concave windows.}

\item{edgeCorrect}{A logical indicating whether to perform edge correction.}

\item{includeZeroCells}{A logical indicating whether to include cells with zero counts in the pairwise association.}

\item{BPPARAM}{\{DEPRECATED\} A BiocParallel MulticoreParam or SerialParam object.}

\item{imageIDCol}{\{DEPRECATED\} The name of the imageID column if using a SingleCellExperiment or SpatialExperiment.}

\item{cellTypeCol}{\{DEPRECATED\} The name of the cellType column if using a SingleCellExperiment or SpatialExperiment.}

\item{spatialCoordCols}{\{DEPRECATED\} The names of the spatialCoords column if using a SingleCellExperiment.}

\item{nCores}{\{DEPRECATED\} Number of cores to use for parallel processing or a BiocParallel MulticoreParam or SerialParam object.}

\item{Rs}{\{DEPRECATED\} A vector of the radii that the measures of association should be calculated over.
calculation.}
}
\value{
Statistic from pairwise L-curve of a single image.
}
\description{
Get statistic from pairwise L curve of a single image.
}
\examples{
data("diabetesData")
# Subset by imageID for fast example
selected_cells <- diabetesData[
  , SummarizedExperiment::colData(diabetesData)$imageID == "A09"
]
pairAssoc <- getPairwise(selected_cells)
}
