% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotCrossHeatmap.R
\name{plotCrossHeatmap}
\alias{plotCrossHeatmap}
\title{Plotting the Result of a Cross Spatial Inference}
\usage{
plotCrossHeatmap(
  resLs,
  adj.pvalue = "BH",
  coefficientsToPlot = NULL,
  QCThreshold = 1e-05,
  QCMetric = "medianMinIntensity",
  ...
)
}
\arguments{
\item{resLs}{a list with four objects: i) the dataframe with the spatial
statistics results transformed and filtered as used for fitting,
ii) the raw spatial statistics results, iii) the designmatrix of the
inference and iv) the fitted pffr object v) the residual standard error per
condition defined as the residual sum of squares divided by the number of
datapoints - sum of the estimated degrees of freedom for the model parameters
as well as other QC metrics}

\item{adj.pvalue}{a pvalue adjustment method as passed to stats::p.adjust
defaults to Benjamini-Hochberg correction of the false discovery rate.}

\item{coefficientsToPlot}{list of which coefficients to plot in the heatmap
defaults to NULL in which case all coefficients are plotted}

\item{QCThreshold}{the threshold on the Quality control metric. Depends
on the function used.}

\item{QCMetric}{the metric to relate the quality of the fit too.}

\item{...}{other parameters passed to \code{ggplot2} functions}
}
\value{
a ggplot2 object
}
\description{
Plotting the Result of a Cross Spatial Inference
}
\examples{
spe <- .loadExample()
#make the condition a factor variable
colData(spe)[["patient_stage"]] <- factor(colData(spe)[["patient_stage"]])
#relevel to have non-diabetic as the reference category
colData(spe)[["patient_stage"]] <- relevel(colData(spe)[["patient_stage"]],
"Non-diabetic")

selection <- c("acinar", "ductal")
resLs <- crossSpatialInference(spe, selection,
                      fun = "Gcross", marks = "cell_type",
                      rSeq = seq(0, 50, length.out = 50), correction = "rs",
                      sample_id = "patient_id",
                      image_id = "image_number", condition = "patient_stage",
                      algorithm = "bam",
                      ncores = 1
                  )
p <- plotCrossHeatmap(resLs, adj.pvalue = "BH")

}
