% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mock.R
\name{mockSVG}
\alias{mockSVG}
\title{Generate count matrix for spatially variable genes.}
\usage{
mockSVG(size, tot_genes, de_genes, return_SPE = FALSE)
}
\arguments{
\item{size}{An \code{integer} scalar. Cells will be spatially arranged on a \verb{size x size} grid. Default: 10, corresponding to 100 cells.}

\item{tot_genes}{An \code{integer} scalar. Total number of genes. Default: 1000.}

\item{de_genes}{An \code{integer} scaler. The number of spatially variable genes.
Default: 100.}

\item{return_SPE}{A \code{logical}, whether to return result as a
\linkS4class{SpatialExperiment}. Default: \code{FALSE}.}
}
\value{
If \code{return_SPE = TRUE}, returns a \linkS4class{SpatialExperiment} object.

If not, a \code{list} containing:
\itemize{
\item \code{coordinates}: \code{data.frame} with \code{x} and \code{y} columns;
\item \code{counts}: \code{matrix} with generated gene counts.
}
}
\description{
Generate count matrix for spatially variable genes.
}
\examples{
spe <- mockSVG(size = 20, tot_genes = 3, de_genes = 1, return_SPE = TRUE)
spe

}
